/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.mapper;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xs2aObjectMapper
extends ObjectMapper {
    private static final Logger log = LoggerFactory.getLogger(Xs2aObjectMapper.class);

    public Xs2aObjectMapper(Xs2aObjectMapper src) {
        super((ObjectMapper)src);
    }

    public <T> Optional<T> toJsonField(InputStream stream, String fieldName, TypeReference<T> typeReference) {
        try {
            JsonNode jsonNode = this.readTree(stream);
            JsonNode fieldNode = jsonNode.get(fieldName);
            if (fieldNode == null) {
                log.info("Couldn't extract field from json, because there is no this field {} at json.", (Object)fieldName);
                return Optional.empty();
            }
            Object value = this.readValue(this.treeAsTokens((TreeNode)fieldNode), typeReference);
            return Optional.ofNullable(value);
        }
        catch (IOException e) {
            log.info("Couldn't extract field {} from json: {}", (Object)fieldName, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public List<String> toJsonGetValuesForField(InputStream stream, String fieldName) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            JsonNode jsonNode = this.readTree(stream);
            values.addAll(jsonNode.findValuesAsText(fieldName));
        }
        catch (IOException e) {
            log.info("Couldn't extract field {} from json: {}", (Object)fieldName, (Object)e.getMessage());
        }
        return values;
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(Xs2aObjectMapper.class);
        return new Xs2aObjectMapper(this);
    }

    public Xs2aObjectMapper() {
    }
}

