/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.mapper;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class Xs2aObjectMapper
extends ObjectMapper {
    public Xs2aObjectMapper(Xs2aObjectMapper src) {
        super((ObjectMapper)src);
    }

    public <T> Optional<T> toJsonField(InputStream stream, String fieldName, TypeReference<T> typeReference) throws IOException {
        JsonNode jsonNode = this.readTree(stream);
        JsonNode fieldNode = jsonNode.get(fieldName);
        if (fieldNode == null) {
            return Optional.empty();
        }
        Object value = this.readValue(this.treeAsTokens((TreeNode)fieldNode), typeReference);
        return Optional.ofNullable(value);
    }

    public List<String> toJsonGetValuesForField(InputStream stream, String fieldName) throws IOException {
        JsonNode jsonNode = this.readTree(stream);
        return new ArrayList<String>(jsonNode.findValuesAsText(fieldName));
    }

    public List<String> toJsonGetListValuesForField(InputStream stream, String fieldName) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        ArrayNode arrayNode = (ArrayNode)this.readTree(stream).get(fieldName);
        if (arrayNode != null) {
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                values.add(((JsonNode)elements.next()).asText());
            }
        }
        return values;
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(Xs2aObjectMapper.class);
        return new Xs2aObjectMapper(this);
    }

    public Xs2aObjectMapper() {
    }
}

