/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.logger.web;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.logger.context.RequestInfo;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class LoggingContextInterceptor
implements ClientHttpRequestInterceptor {
    private static final String INTERNAL_REQUEST_ID_HEADER_NAME = "X-Internal-Request-ID";
    private static final String X_REQUEST_ID_HEADER_NAME = "X-Request-ID";
    private final LoggingContextService loggingContextService;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        RequestInfo requestInformation = this.loggingContextService.getRequestInformation();
        HttpHeaders requestHeaders = request.getHeaders();
        requestHeaders.add(INTERNAL_REQUEST_ID_HEADER_NAME, requestInformation.getInternalRequestId());
        requestHeaders.add(X_REQUEST_ID_HEADER_NAME, requestInformation.getXRequestId());
        return execution.execute(request, body);
    }

    @ConstructorProperties(value={"loggingContextService"})
    public LoggingContextInterceptor(LoggingContextService loggingContextService) {
        this.loggingContextService = loggingContextService;
    }
}

