/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.logger.web;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.logger.context.RequestInfo;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractLoggingContextFilter
extends OncePerRequestFilter {
    private static final String INTERNAL_REQUEST_ID_HEADER_NAME = "X-Internal-Request-ID";
    private static final String X_REQUEST_ID_HEADER_NAME = "X-Request-ID";
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private final LoggingContextService loggingContextService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestInfo requestInfo = new RequestInfo(request.getHeader(INTERNAL_REQUEST_ID_HEADER_NAME), request.getHeader(X_REQUEST_ID_HEADER_NAME));
        this.loggingContextService.storeRequestInformation(requestInfo);
        try {
            this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
        finally {
            this.loggingContextService.clearContext();
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String pathWithinApplication = URL_PATH_HELPER.getPathWithinApplication(request);
        return !pathWithinApplication.startsWith(this.getEndpointsPrefix());
    }

    protected abstract String getEndpointsPrefix();

    @ConstructorProperties(value={"loggingContextService"})
    public AbstractLoggingContextFilter(LoggingContextService loggingContextService) {
        this.loggingContextService = loggingContextService;
    }
}

