/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.logger.context;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.logger.context.RequestInfo;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class MdcLoggingContextService
implements LoggingContextService {
    private static final String TRANSACTION_STATUS_KEY = "transactionStatus";
    private static final String CONSENT_STATUS_KEY = "consentStatus";
    private static final String SCA_STATUS_KEY = "scaStatus";
    private static final String INTERNAL_REQUEST_ID_KEY = "internal-request-id";
    private static final String X_REQUEST_ID_KEY = "x-request-id";
    private static final String INSTANCE_ID_KEY = "instance-id";

    @Override
    public void storeConsentStatus(@NotNull ConsentStatus consentStatus) {
        MDC.put((String)CONSENT_STATUS_KEY, (String)consentStatus.getValue());
    }

    @Override
    public String getConsentStatus() {
        return MDC.get((String)CONSENT_STATUS_KEY);
    }

    @Override
    public void storeTransactionStatus(@NotNull TransactionStatus transactionStatus) {
        MDC.put((String)TRANSACTION_STATUS_KEY, (String)transactionStatus.getTransactionStatus());
    }

    @Override
    public String getTransactionStatus() {
        return MDC.get((String)TRANSACTION_STATUS_KEY);
    }

    @Override
    public void storeScaStatus(@NotNull ScaStatus scaStatus) {
        MDC.put((String)SCA_STATUS_KEY, (String)scaStatus.getValue());
    }

    @Override
    public void storeTransactionAndScaStatus(@NotNull TransactionStatus transactionStatus, @Nullable ScaStatus scaStatus) {
        this.storeTransactionStatus(transactionStatus);
        if (scaStatus != null) {
            this.storeScaStatus(scaStatus);
        }
    }

    @Override
    public String getScaStatus() {
        return MDC.get((String)SCA_STATUS_KEY);
    }

    @Override
    public void storeRequestInformation(RequestInfo requestInfo) {
        if (requestInfo == null) {
            return;
        }
        MDC.put((String)INTERNAL_REQUEST_ID_KEY, (String)requestInfo.getInternalRequestId());
        MDC.put((String)X_REQUEST_ID_KEY, (String)requestInfo.getXRequestId());
        MDC.put((String)INSTANCE_ID_KEY, (String)requestInfo.getInstanceId());
    }

    @Override
    public RequestInfo getRequestInformation() {
        String internalRequestId = MDC.get((String)INTERNAL_REQUEST_ID_KEY);
        String xRequestId = MDC.get((String)X_REQUEST_ID_KEY);
        String instanceId = MDC.get((String)INSTANCE_ID_KEY);
        return new RequestInfo(internalRequestId, xRequestId, instanceId);
    }

    @Override
    public void clearContext() {
        MDC.clear();
    }
}

