/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.header;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.NotificationModeResponseHeaders;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.header.AbstractHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsentHeadersBuilder
extends AbstractHeadersBuilder {
    @Autowired
    public ConsentHeadersBuilder(ScaApproachResolver scaApproachResolver) {
        super(scaApproachResolver);
    }

    public ResponseHeaders buildCreateConsentHeaders(@Nullable String authorisationId, @NotNull String selfLink, @NotNull NotificationModeResponseHeaders notificationHeaders) {
        ResponseHeaders.ResponseHeadersBuilder responseHeadersBuilder = ResponseHeaders.builder();
        this.buildNotificationHeaders(responseHeadersBuilder, notificationHeaders);
        this.buildCreateConsentHeaders(responseHeadersBuilder, authorisationId, selfLink);
        return responseHeadersBuilder.build();
    }

    private void buildNotificationHeaders(ResponseHeaders.ResponseHeadersBuilder builder, @NotNull NotificationModeResponseHeaders notificationHeaders) {
        builder.notificationSupport(notificationHeaders.getAspspNotificationSupport());
        builder.notificationContent(notificationHeaders.getAspspNotificationContent());
    }

    private void buildCreateConsentHeaders(ResponseHeaders.ResponseHeadersBuilder builder, @Nullable String authorisationId, @NotNull String selfLink) {
        builder.location(selfLink);
        if (authorisationId != null) {
            ScaApproach scaApproach = this.scaApproachResolver.getScaApproach(authorisationId);
            builder.aspspScaApproach(scaApproach);
        }
    }

    public ResponseHeaders buildCreateConsentHeaders(@Nullable String authorisationId, @NotNull String selfLink) {
        ResponseHeaders.ResponseHeadersBuilder responseHeadersBuilder = ResponseHeaders.builder();
        this.buildCreateConsentHeaders(responseHeadersBuilder, authorisationId, selfLink);
        return responseHeadersBuilder.build();
    }
}

