/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;

@Component
public class SwaggerResourceBuilder {
    private static final String DEFAULT_PSD2_API_LOCATION = "/psd2-api_1.3.8_2020-11-06v1.yaml";
    private static final String DEFAULT_PSD2_API_FUNDS_CONFIRMATION_LOCATION = "/psd2-confirmation-of-funds-consent-2.0-20190607.yaml";
    @Value(value="${xs2a.swagger.psd2.api.location:}")
    private String customPsd2ApiLocation;

    public SwaggerResource buildPSD2ApiV1() {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setLocation(this.resolveYamlLocation());
        swaggerResource.setName("Berlin Group PSD2 API v1");
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    public SwaggerResource buildFundsConfirmationApiV2() {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setLocation(DEFAULT_PSD2_API_FUNDS_CONFIRMATION_LOCATION);
        swaggerResource.setName("Berlin Group PSD2 Funds confirmation API v2");
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    private String resolveYamlLocation() {
        if (StringUtils.isBlank((CharSequence)this.customPsd2ApiLocation)) {
            return DEFAULT_PSD2_API_LOCATION;
        }
        return this.customPsd2ApiLocation;
    }
}

