/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.piis;

import de.adorsys.psd2.model.Error406NGPIIS;
import de.adorsys.psd2.model.TppMessage406PIIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIIS406ErrorMapper
extends Psd2ErrorMapper<MessageError, Error406NGPIIS> {
    @Override
    public Function<MessageError, Error406NGPIIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.NOT_ACCEPTABLE;
    }

    private Error406NGPIIS mapToPsd2Error(MessageError messageError) {
        return new Error406NGPIIS().tppMessages(this.mapToTppMessages(messageError.getTppMessages()));
    }

    private List<TppMessage406PIIS> mapToTppMessages(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage406PIIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

