/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.BalanceMapper;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountModelMapperImpl
extends AccountModelMapper {
    @Autowired
    private BalanceMapper balanceMapper;

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setCurrency(this.accountReferenceCurrencyCurrencyCode(accountReference));
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setOtherAccountIdentification(accountReference.getOtherAccountIdentification());
        return accountReference1;
    }

    @Override
    public List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> accountReferences) {
        if (accountReferences == null) {
            return null;
        }
        ArrayList<AccountReference> list = new ArrayList<AccountReference>(accountReferences.size());
        for (de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference : accountReferences) {
            list.add(this.mapToAccountReference(accountReference));
        }
        return list;
    }

    @Override
    public AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        AccountDetails accountDetails1 = new AccountDetails();
        accountDetails1.setStatus(this.accountStatusToAccountStatus(accountDetails.getAccountStatus()));
        accountDetails1.setUsage(this.xs2aUsageTypeToUsageEnum(accountDetails.getUsageType()));
        accountDetails1.setResourceId(accountDetails.getResourceId());
        accountDetails1.setIban(accountDetails.getIban());
        accountDetails1.setBban(accountDetails.getBban());
        accountDetails1.setMsisdn(accountDetails.getMsisdn());
        accountDetails1.setName(accountDetails.getName());
        accountDetails1.setDisplayName(accountDetails.getDisplayName());
        accountDetails1.setProduct(accountDetails.getProduct());
        if (accountDetails.getCashAccountType() != null) {
            accountDetails1.setCashAccountType(accountDetails.getCashAccountType().name());
        }
        accountDetails1.setBic(accountDetails.getBic());
        accountDetails1.setLinkedAccounts(accountDetails.getLinkedAccounts());
        accountDetails1.setDetails(accountDetails.getDetails());
        accountDetails1.setBalances(this.balanceMapper.mapToBalanceList(accountDetails.getBalances()));
        accountDetails1.setOwnerName(accountDetails.getOwnerName());
        accountDetails1.setLinks(this.hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()));
        accountDetails1.setCurrency(this.mapToAccountDetailsCurrency(accountDetails.getCurrency()));
        return accountDetails1;
    }

    @Override
    public ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        ReadAccountBalanceResponse200 readAccountBalanceResponse200 = new ReadAccountBalanceResponse200();
        readAccountBalanceResponse200.setAccount(this.mapToAccountReference(balancesReport.getXs2aAccountReference()));
        readAccountBalanceResponse200.setBalances(this.balanceMapper.mapToBalanceList(balancesReport.getBalances()));
        return readAccountBalanceResponse200;
    }

    private String accountReferenceCurrencyCurrencyCode(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        Currency currency = accountReference.getCurrency();
        if (currency == null) {
            return null;
        }
        String currencyCode = currency.getCurrencyCode();
        if (currencyCode == null) {
            return null;
        }
        return currencyCode;
    }

    protected AccountStatus accountStatusToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        AccountStatus accountStatus1;
        if (accountStatus == null) {
            return null;
        }
        switch (accountStatus) {
            case ENABLED: {
                accountStatus1 = AccountStatus.ENABLED;
                break;
            }
            case DELETED: {
                accountStatus1 = AccountStatus.DELETED;
                break;
            }
            case BLOCKED: {
                accountStatus1 = AccountStatus.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountStatus);
            }
        }
        return accountStatus1;
    }

    protected AccountDetails.UsageEnum xs2aUsageTypeToUsageEnum(Xs2aUsageType xs2aUsageType) {
        AccountDetails.UsageEnum usageEnum;
        if (xs2aUsageType == null) {
            return null;
        }
        switch (xs2aUsageType) {
            case PRIV: {
                usageEnum = AccountDetails.UsageEnum.PRIV;
                break;
            }
            case ORGA: {
                usageEnum = AccountDetails.UsageEnum.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + xs2aUsageType);
            }
        }
        return usageEnum;
    }
}

