/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceReportMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AccountMappersHolder {
    private final SpiToXs2aBalanceReportMapper balanceReportMapper;
    private final Xs2aAisConsentMapper consentMapper;
    private final SpiErrorMapper spiErrorMapper;

    public SpiAccountConsent mapToSpiAccountConsent(AisConsent aisConsent) {
        return this.consentMapper.mapToSpiAccountConsent(aisConsent);
    }

    public ErrorHolder mapToErrorHolder(SpiResponse<List<SpiAccountBalance>> spiResponse, ServiceType serviceType) {
        return this.spiErrorMapper.mapToErrorHolder(spiResponse, serviceType);
    }

    public Xs2aBalancesReport mapToXs2aBalancesReportSpi(SpiAccountReference spiAccountReference, List<SpiAccountBalance> spiAccountBalances) {
        return this.balanceReportMapper.mapToXs2aBalancesReportSpi(spiAccountReference, spiAccountBalances);
    }

    public Xs2aBalancesReport mapToXs2aBalancesReport(AccountReference accountReference, List<SpiAccountBalance> spiAccountBalances) {
        return this.balanceReportMapper.mapToXs2aBalancesReport(accountReference, spiAccountBalances);
    }

    @ConstructorProperties(value={"balanceReportMapper", "consentMapper", "spiErrorMapper"})
    public AccountMappersHolder(SpiToXs2aBalanceReportMapper balanceReportMapper, Xs2aAisConsentMapper consentMapper, SpiErrorMapper spiErrorMapper) {
        this.balanceReportMapper = balanceReportMapper;
        this.consentMapper = consentMapper;
        this.spiErrorMapper = spiErrorMapper;
    }
}

