/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.PisAuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.PisCancellationAuthorisationParentHolder;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationChainResponsibilityService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.PisAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.PisCancellationAuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationService.class);
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final Xs2aPisCommonPaymentMapper pisCommonPaymentMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final RequestProviderService requestProviderService;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final AuthorisationChainResponsibilityService authorisationChainResponsibilityService;

    public CreateAuthorisationResponse createPisAuthorisation(String paymentId, PsuIdData psuData) {
        TppRedirectUri redirectURIs = this.tppRedirectUriMapper.mapToTppRedirectUri(this.requestProviderService.getTppRedirectURI(), this.requestProviderService.getTppNokRedirectURI());
        CreateAuthorisationRequest request = new CreateAuthorisationRequest(psuData, this.scaApproachResolver.resolveScaApproach(), redirectURIs);
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.createAuthorisation((AuthorisationParentHolder)new PisAuthorisationParentHolder(paymentId), request);
        if (cmsResponse.hasError()) {
            log.info("Payment-ID [{}]. Create PIS authorisation has failed: can't save authorisation to cms DB", (Object)paymentId);
            return null;
        }
        return (CreateAuthorisationResponse)cmsResponse.getPayload();
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        String authorisationId = request.getAuthorisationId();
        CmsResponse pisAuthorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        if (pisAuthorisationResponse.hasError()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_404).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_AUTHORISATION)}).build();
            log.info("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed: authorisation is not found by id.", (Object)request.getPaymentId(), (Object)request.getAuthorisationId());
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, request.getPaymentId(), authorisationId, request.getPsuData());
        }
        Authorisation response = (Authorisation)pisAuthorisationResponse.getPayload();
        return (Xs2aUpdatePisCommonPaymentPsuDataResponse)this.authorisationChainResponsibilityService.apply(new PisAuthorisationProcessorRequest(scaApproach, response.getScaStatus(), request, response));
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisCancellationAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        String authorisationId = request.getAuthorisationId();
        CmsResponse pisCancellationAuthorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(request.getAuthorisationId());
        if (pisCancellationAuthorisationResponse.hasError()) {
            log.warn("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS Payment Cancellation authorisation PSU Data has failed: authorisation is not found by id.", (Object)request.getPaymentId(), (Object)request.getAuthorisationId());
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_404).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_CANC_AUTHORISATION)}).build();
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, request.getPaymentId(), authorisationId, request.getPsuData());
        }
        Authorisation response = (Authorisation)pisCancellationAuthorisationResponse.getPayload();
        return (Xs2aUpdatePisCommonPaymentPsuDataResponse)this.authorisationChainResponsibilityService.apply(new PisCancellationAuthorisationProcessorRequest(scaApproach, response.getScaStatus(), request, response));
    }

    public CreateAuthorisationResponse createPisAuthorisationCancellation(String paymentId, PsuIdData psuData) {
        TppRedirectUri redirectURIs = this.tppRedirectUriMapper.mapToTppRedirectUri(this.requestProviderService.getTppRedirectURI(), this.requestProviderService.getTppNokRedirectURI());
        CreateAuthorisationRequest request = new CreateAuthorisationRequest(psuData, this.scaApproachResolver.resolveScaApproach(), redirectURIs);
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.createAuthorisation((AuthorisationParentHolder)new PisCancellationAuthorisationParentHolder(paymentId), request);
        if (cmsResponse.hasError()) {
            log.info("Payment-ID [{}]. Create PIS Payment Cancellation Authorisation has failed. Can't find Payment Data by id or Payment is Finalised.", (Object)paymentId);
            return null;
        }
        return (CreateAuthorisationResponse)cmsResponse.getPayload();
    }

    public Optional<List<String>> getCancellationAuthorisationSubResources(String paymentId) {
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.getAuthorisationsByParentId((AuthorisationParentHolder)new PisCancellationAuthorisationParentHolder(paymentId));
        if (cmsResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((List)cmsResponse.getPayload());
    }

    public Optional<List<String>> getAuthorisationSubResources(String paymentId) {
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.getAuthorisationsByParentId((AuthorisationParentHolder)new PisAuthorisationParentHolder(paymentId));
        if (cmsResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((List)cmsResponse.getPayload());
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String paymentId, String authorisationId) {
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.getAuthorisationScaStatus(authorisationId, (AuthorisationParentHolder)new PisAuthorisationParentHolder(paymentId));
        if (cmsResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ScaStatus)cmsResponse.getPayload());
    }

    public Optional<ScaStatus> getCancellationAuthorisationScaStatus(String paymentId, String authorisationId) {
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.getAuthorisationScaStatus(authorisationId, (AuthorisationParentHolder)new PisCancellationAuthorisationParentHolder(paymentId));
        if (cmsResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ScaStatus)cmsResponse.getPayload());
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        CmsResponse cmsResponse = this.authorisationServiceEncrypted.getAuthorisationScaApproach(authorisationId);
        if (cmsResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((AuthorisationScaApproachResponse)cmsResponse.getPayload());
    }

    public void updateAuthorisation(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        if (response.hasError()) {
            log.warn("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed. Error msg: [{}]", new Object[]{request.getBusinessObjectId(), request.getAuthorisationId(), response.getErrorHolder()});
        } else {
            this.authorisationServiceEncrypted.updateAuthorisation(request.getAuthorisationId(), this.pisCommonPaymentMapper.mapToUpdateAuthorisationRequest(response, AuthorisationType.PIS_CREATION));
        }
    }

    public void updateCancellationAuthorisation(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        if (response.hasError()) {
            log.warn("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS Payment Cancellation authorisation PSU Data has failed:. Error msg: [{}]", new Object[]{request.getBusinessObjectId(), request.getAuthorisationId(), response.getErrorHolder()});
        } else {
            this.authorisationServiceEncrypted.updateAuthorisation(request.getAuthorisationId(), this.pisCommonPaymentMapper.mapToUpdateAuthorisationRequest(response, AuthorisationType.PIS_CANCELLATION));
        }
    }

    @ConstructorProperties(value={"authorisationServiceEncrypted", "pisCommonPaymentMapper", "scaApproachResolver", "requestProviderService", "tppRedirectUriMapper", "authorisationChainResponsibilityService"})
    public PisAuthorisationService(AuthorisationServiceEncrypted authorisationServiceEncrypted, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper, ScaApproachResolver scaApproachResolver, RequestProviderService requestProviderService, TppRedirectUriMapper tppRedirectUriMapper, AuthorisationChainResponsibilityService authorisationChainResponsibilityService) {
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.requestProviderService = requestProviderService;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.authorisationChainResponsibilityService = authorisationChainResponsibilityService;
    }
}

