/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaApproachResolver {
    private static final Logger log = LoggerFactory.getLogger(ScaApproachResolver.class);
    private final Xs2aAuthorisationService xs2aAuthorisationService;
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;

    public ScaApproachResolver(Xs2aAuthorisationService xs2aAuthorisationService, AspspProfileService aspspProfileService, RequestProviderService requestProviderService) {
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
    }

    public ScaApproach resolveScaApproach() {
        List scaApproaches = this.aspspProfileService.getScaApproaches(this.requestProviderService.getInstanceId());
        ScaApproach firstScaApproach = this.getFirst(scaApproaches);
        Optional<Boolean> tppRedirectPreferredOptional = this.requestProviderService.resolveTppRedirectPreferred();
        if (tppRedirectPreferredOptional.isEmpty()) {
            return firstScaApproach;
        }
        boolean tppRedirectPreferred = tppRedirectPreferredOptional.get();
        if (tppRedirectPreferred && scaApproaches.contains(ScaApproach.REDIRECT)) {
            return ScaApproach.REDIRECT;
        }
        if (!tppRedirectPreferred && ScaApproach.REDIRECT == firstScaApproach && scaApproaches.size() > 1) {
            return this.getSecond(scaApproaches);
        }
        return firstScaApproach;
    }

    @NotNull
    public ScaApproach getScaApproach(@NotNull String authorisationId) {
        return this.resolveScaApproach(authorisationId);
    }

    @NotNull
    private ScaApproach resolveScaApproach(@NotNull String authorisationId) {
        Optional<AuthorisationScaApproachResponse> scaApproachResponse = this.xs2aAuthorisationService.getAuthorisationScaApproach(authorisationId);
        if (scaApproachResponse.isEmpty()) {
            log.info("Couldn't retrieve SCA approach from the authorisation with id: {}", (Object)authorisationId);
            throw new IllegalArgumentException("Wrong authorisation id: " + authorisationId);
        }
        return scaApproachResponse.get().getScaApproach();
    }

    private ScaApproach getFirst(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(0);
    }

    private ScaApproach getSecond(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(1);
    }
}

