/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum ContentType {
    XML("application/xml"),
    JSON("application/json"),
    TXT("text/plain"),
    EMPTY("*/*");

    private static final Map<String, ContentType> CONTAINER;
    private String type;

    private ContentType(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static ContentType extract(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String[] parts = type.split(";");
            return CONTAINER.get(parts[0]);
        }
        return null;
    }

    static {
        CONTAINER = new HashMap<String, ContentType>();
        for (ContentType t : ContentType.values()) {
            CONTAINER.put(t.getType(), t);
        }
    }
}

