package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.OtpFormat;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiChallengeData;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiOtpFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-02-24T11:31:18+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.10 (Azul Systems, Inc.)"
)
@Component
public class SpiToXs2aChallengeDataMapperImpl implements SpiToXs2aChallengeDataMapper {

    @Override
    public ChallengeData toChallengeData(SpiChallengeData spiChallengeData) {
        if ( spiChallengeData == null ) {
            return null;
        }

        ChallengeData challengeData = new ChallengeData();

        byte[] image = spiChallengeData.getImage();
        if ( image != null ) {
            challengeData.setImage( Arrays.copyOf( image, image.length ) );
        }
        List<String> list = spiChallengeData.getData();
        if ( list != null ) {
            challengeData.setData( new ArrayList<String>( list ) );
        }
        challengeData.setImageLink( spiChallengeData.getImageLink() );
        challengeData.setOtpMaxLength( spiChallengeData.getOtpMaxLength() );
        challengeData.setOtpFormat( spiOtpFormatToOtpFormat( spiChallengeData.getOtpFormat() ) );
        challengeData.setAdditionalInformation( spiChallengeData.getAdditionalInformation() );

        return challengeData;
    }

    protected OtpFormat spiOtpFormatToOtpFormat(SpiOtpFormat spiOtpFormat) {
        if ( spiOtpFormat == null ) {
            return null;
        }

        OtpFormat otpFormat;

        switch ( spiOtpFormat ) {
            case CHARACTERS: otpFormat = OtpFormat.CHARACTERS;
            break;
            case INTEGER: otpFormat = OtpFormat.INTEGER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + spiOtpFormat );
        }

        return otpFormat;
    }
}
