/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MultiPartBoundaryBuilder {
    private static final Logger log = LoggerFactory.getLogger(MultiPartBoundaryBuilder.class);
    static final String DEFAULT_BOUNDARY = "--AaaBbbCcc";
    private static final String BOUNDARY = "boundary=";
    private static final String BOUNDARY_PLACEHOLDER = "{BOUNDARY}";
    private static final String XMLPART_PLACEHOLDER = "{XML_PART}";
    private static final String JSONPART_PLACEHOLDER = "{JSON_PART}";
    private static final String BOUNDARY_PREFIX = "--";
    private static String contentTemplate = null;

    public String getMultiPartContent(HttpServletRequest request, String xmlSct, String jsonPart) {
        String contentTypeHeader = request.getHeader("Content-Type");
        Object boundary = DEFAULT_BOUNDARY;
        if (contentTypeHeader != null && contentTypeHeader.contains("multipart/form-data") && contentTypeHeader.contains(BOUNDARY)) {
            String boundaryValue = contentTypeHeader.substring(contentTypeHeader.indexOf(BOUNDARY) + BOUNDARY.length());
            boundary = boundaryValue.startsWith(BOUNDARY_PREFIX) ? boundaryValue : BOUNDARY_PREFIX + boundaryValue;
        }
        return contentTemplate.replace(BOUNDARY_PLACEHOLDER, (CharSequence)boundary).replace(XMLPART_PLACEHOLDER, xmlSct).replace(JSONPART_PLACEHOLDER, jsonPart).trim();
    }

    static {
        try {
            contentTemplate = IOUtils.resourceToString((String)"/template/multipart-payment-template.txt", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Reading multipart payment template failed: {}", (Object)e.getMessage());
        }
    }
}

