/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.advice;

import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@Component
public class Xs2aRestExceptionHandler
extends DefaultHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(Xs2aRestExceptionHandler.class);
    private final TppErrorMessageWriter tppErrorMessageWriter;
    private final Xs2aEndpointChecker xs2aEndpointChecker;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.xs2aEndpointChecker.isXs2aEndpoint(request)) {
            return super.doResolveException(request, response, handler, ex);
        }
        return null;
    }

    protected ModelAndView handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, MessageErrorCode.SERVICE_INVALID_405_METHOD_NOT_SUPPORTED, ex.getMethod()));
        return new ModelAndView();
    }

    protected ModelAndView handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, MessageErrorCode.REQUESTED_FORMATS_INVALID, new Object[0]));
        return new ModelAndView();
    }

    @ConstructorProperties(value={"tppErrorMessageWriter", "xs2aEndpointChecker"})
    public Xs2aRestExceptionHandler(TppErrorMessageWriter tppErrorMessageWriter, Xs2aEndpointChecker xs2aEndpointChecker) {
        this.tppErrorMessageWriter = tppErrorMessageWriter;
        this.xs2aEndpointChecker = xs2aEndpointChecker;
    }
}

