/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TransactionStatusAcceptHeaderValidator {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public ValidationResult validate(@NotNull String acceptHeader) {
        if (acceptHeader.equalsIgnoreCase("*/*")) {
            return ValidationResult.valid();
        }
        List<String> supportedTransactionStatusFormats = this.aspspProfileServiceWrapper.getSupportedTransactionStatusFormats();
        if (!this.isMediaTypeSupported(acceptHeader, supportedTransactionStatusFormats)) {
            return ValidationResult.invalid((ErrorType)ErrorType.PIS_406, (MessageErrorCode)MessageErrorCode.REQUESTED_FORMATS_INVALID);
        }
        return ValidationResult.valid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMediaTypeSupported(String requestedMediaType, List<String> supportedMediaTypes) {
        List acceptHeaders = Stream.of(requestedMediaType.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(supportedMediaTypes)) return true;
        if (!supportedMediaTypes.stream().filter(Objects::nonNull).map(String::toLowerCase).map(String::trim).anyMatch(acceptHeaders.stream().map(String::toLowerCase).map(String::trim).collect(Collectors.toSet())::contains)) return false;
        return true;
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public TransactionStatusAcceptHeaderValidator(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

