/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppDomainValidator;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TppNotificationDataValidator
implements BusinessValidator<TppNotificationData> {
    private final TppDomainValidator tppDomainValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull TppNotificationData tppNotificationData) {
        return ValidationResult.valid();
    }

    @Override
    @NotNull
    public Set<TppMessageInformation> buildWarningMessages(@NotNull TppNotificationData tppNotificationData) {
        if (CollectionUtils.isNotEmpty((Collection)tppNotificationData.getNotificationModes()) && StringUtils.isNotBlank((CharSequence)tppNotificationData.getTppNotificationUri())) {
            return this.tppDomainValidator.buildWarningMessages(tppNotificationData.getTppNotificationUri());
        }
        return Collections.emptySet();
    }

    @ConstructorProperties(value={"tppDomainValidator"})
    public TppNotificationDataValidator(TppDomainValidator tppDomainValidator) {
        this.tppDomainValidator = tppDomainValidator;
    }
}

