/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor.service;

import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.BaseAuthorisationProcessorService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ConsentAuthorisationProcessorService<T extends Consent>
extends BaseAuthorisationProcessorService {
    private static final String CONSENT_NOT_FOUND_LOG_MESSAGE = "Apply authorisation when update consent PSU data has failed. Consent not found by id.";
    private final Xs2aAuthorisationService authorisationService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;

    protected ConsentAuthorisationProcessorService(Xs2aAuthorisationService authorisationService, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, Xs2aToSpiPsuDataMapper psuDataMapper) {
        this.authorisationService = authorisationService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.psuDataMapper = psuDataMapper;
    }

    @Override
    public AuthorisationProcessorResponse doScaReceived(AuthorisationProcessorRequest authorisationProcessorRequest) {
        return this.doScaPsuIdentified(authorisationProcessorRequest);
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuIdentified(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        return request.isUpdatePsuIdentification() ? this.applyIdentification(authorisationProcessorRequest) : this.applyAuthorisation(authorisationProcessorRequest);
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuAuthenticated(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<T> consentOptional = this.getConsentByIdFromCms(consentId);
        if (consentOptional.isEmpty()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        PsuIdData psuData = this.extractPsuIdData(request, authorisationProcessorRequest.getAuthorisation());
        Consent consent = (Consent)consentOptional.get();
        String authenticationMethodId = request.getAuthenticationMethodId();
        if (this.isDecoupledApproach(request.getAuthorisationId(), authenticationMethodId)) {
            this.authorisationService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.proceedDecoupledApproach(request.getBusinessObjectId(), request.getAuthorisationId(), consent, authenticationMethodId, psuData);
        }
        return this.proceedEmbeddedApproach(authorisationProcessorRequest, authenticationMethodId, consent, psuData);
    }

    @Override
    public AuthorisationProcessorResponse doScaMethodSelected(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<T> consentOptional = this.getConsentByIdFromCms(consentId);
        if (consentOptional.isEmpty()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        Consent consent = (Consent)consentOptional.get();
        PsuIdData psuData = this.extractPsuIdData(request, authorisationProcessorRequest.getAuthorisation());
        SpiResponse<SpiVerifyScaAuthorisationResponse> spiResponse = this.verifyScaAuthorisation(this.spiContextDataProvider.provideWithPsuIdData(psuData), request, psuData, consent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, this.getServiceType());
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, "Verify SCA authorisation failed when update PSU data.");
            SpiVerifyScaAuthorisationResponse spiAuthorisationResponse = (SpiVerifyScaAuthorisationResponse)spiResponse.getPayload();
            return this.getSpiErrorResponse(authorisationProcessorRequest, consentId, authorisationId, psuData, errorHolder, spiAuthorisationResponse);
        }
        ConsentStatus responseConsentStatus = ((SpiVerifyScaAuthorisationResponse)spiResponse.getPayload()).getConsentStatus();
        if (ConsentStatus.PARTIALLY_AUTHORISED == responseConsentStatus && !consent.isMultilevelScaRequired()) {
            this.updateMultilevelScaRequired(consentId, true);
        }
        if (consent.getConsentStatus() != responseConsentStatus) {
            this.updateConsentStatus(consentId, responseConsentStatus);
        }
        this.findAndTerminateOldConsentsByNewConsentId(consentId);
        return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, request.getAuthorisationId(), psuData);
    }

    private AuthorisationProcessorResponse getSpiErrorResponse(AuthorisationProcessorRequest authorisationProcessorRequest, String consentId, String authorisationId, PsuIdData psuData, ErrorHolder errorHolder, SpiVerifyScaAuthorisationResponse spiAuthorisationResponse) {
        if (spiAuthorisationResponse != null && spiAuthorisationResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.ATTEMPT_FAILURE) {
            return new UpdateConsentPsuDataResponse(authorisationProcessorRequest.getScaStatus(), errorHolder, consentId, authorisationId, psuData);
        }
        Optional first = errorHolder.getFirstErrorCode();
        if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
            this.authorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
        }
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
    }

    @Override
    public AuthorisationProcessorResponse doScaFinalised(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
    }

    private UpdateConsentPsuDataResponse proceedEmbeddedApproach(AuthorisationProcessorRequest authorisationProcessorRequest, String authenticationMethodId, T consent, PsuIdData psuData) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.requestAuthorisationCode(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationMethodId, consent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getBusinessObjectId()));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, this.getServiceType());
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Proceed embedded approach when performs authorisation depending on selected SCA method has failed.");
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.authorisationService.updateAuthorisationStatus(request.getAuthorisationId(), ScaStatus.FAILED);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, request.getBusinessObjectId(), request.getAuthorisationId(), psuData);
        }
        SpiAuthorizationCodeResult authorizationCodeResult = (SpiAuthorizationCodeResult)spiResponse.getPayload();
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(authorizationCodeResult.getScaStatus(), request.getBusinessObjectId(), request.getAuthorisationId(), psuData);
        response.setChosenScaMethod(authorizationCodeResult.getSelectedScaMethod());
        response.setChallengeData(authorizationCodeResult.getChallengeData());
        return response;
    }

    private UpdateConsentPsuDataResponse applyAuthorisation(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<T> consentOptional = this.getConsentByIdFromCms(consentId);
        if (consentOptional.isEmpty()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        Consent consent = (Consent)consentOptional.get();
        SpiResponse<SpiPsuAuthorisationResponse> authorisationStatusSpiResponse = this.authorisePsu(this.spiContextDataProvider.provideWithPsuIdData(psuData), authorisation.getAuthorisationId(), this.psuDataMapper.mapToSpiPsuData(psuData), request.getPassword(), consent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        SpiPsuAuthorisationResponse spiAuthorisationResponse = (SpiPsuAuthorisationResponse)authorisationStatusSpiResponse.getPayload();
        if (authorisationStatusSpiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(authorisationStatusSpiResponse, this.getServiceType());
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Authorise PSU when apply authorisation has failed.");
            if (spiAuthorisationResponse != null && spiAuthorisationResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.ATTEMPT_FAILURE) {
                return new UpdateConsentPsuDataResponse(authorisationProcessorRequest.getScaStatus(), errorHolder, consentId, authorisationId, psuData);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        if (spiAuthorisationResponse != null && spiAuthorisationResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.FAILURE) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType401()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID)}).build();
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Authorise PSU when apply authorisation has failed. PSU credentials invalid.");
            this.authorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        if (this.isOneFactorAuthorisation(consent)) {
            this.updateConsentStatus(consentId, ConsentStatus.VALID);
            return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, authorisationId, psuData);
        }
        return this.requestAvailableScaMethods(authorisationProcessorRequest, consentId, authorisationId, psuData, consent);
    }

    private UpdateConsentPsuDataResponse requestAvailableScaMethods(AuthorisationProcessorRequest authorisationProcessorRequest, String consentId, String authorisationId, PsuIdData psuData, T consent) {
        SpiResponse<SpiAvailableScaMethodsResponse> spiResponse = this.requestAvailableScaMethods(this.spiContextDataProvider.provideWithPsuIdData(psuData), consent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, this.getServiceType());
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Request available SCA methods when apply authorisation has failed.");
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        List availableScaMethods = ((SpiAvailableScaMethodsResponse)spiResponse.getPayload()).getAvailableScaMethods();
        return this.processScaMethods(authorisationProcessorRequest, consentId, authorisationId, psuData, consent, availableScaMethods);
    }

    private UpdateConsentPsuDataResponse processScaMethods(AuthorisationProcessorRequest authorisationProcessorRequest, String consentId, String authorisationId, PsuIdData psuData, T consent, List<AuthenticationObject> availableScaMethods) {
        if (CollectionUtils.isEmpty(availableScaMethods)) {
            return this.buildUpdateResponseWithoutSca(authorisationProcessorRequest, consentId, authorisationId, psuData);
        }
        if (this.isMultipleScaMethods(availableScaMethods)) {
            return this.createResponseForMultipleAvailableMethods(availableScaMethods, authorisationId, consentId, psuData);
        }
        return this.createResponseForOneAvailableMethod(authorisationProcessorRequest, consent, availableScaMethods, psuData);
    }

    private UpdateConsentPsuDataResponse buildUpdateResponseWithoutSca(AuthorisationProcessorRequest authorisationProcessorRequest, String consentId, String authorisationId, PsuIdData psuData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SCA_METHOD_UNKNOWN)}).build();
        this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Apply authorisation has failed. Consent was rejected because PSU has no available SCA methods.");
        this.updateConsentStatus(consentId, ConsentStatus.REJECTED);
        this.authorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
    }

    private UpdateConsentPsuDataResponse createResponseForMultipleAvailableMethods(List<AuthenticationObject> availableScaMethods, String authorisationId, String consentId, PsuIdData psuIdData) {
        this.authorisationService.saveAuthenticationMethods(authorisationId, availableScaMethods);
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.PSUAUTHENTICATED, consentId, authorisationId, psuIdData);
        response.setAvailableScaMethods(availableScaMethods);
        return response;
    }

    private UpdateConsentPsuDataResponse createResponseForOneAvailableMethod(AuthorisationProcessorRequest authorisationProcessorRequest, T consent, List<AuthenticationObject> availableScaMethods, PsuIdData psuData) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        this.authorisationService.saveAuthenticationMethods(request.getAuthorisationId(), availableScaMethods);
        AuthenticationObject chosenMethod = availableScaMethods.get(0);
        if (chosenMethod.isDecoupled()) {
            this.authorisationService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.proceedDecoupledApproach(request.getBusinessObjectId(), request.getAuthorisationId(), consent, chosenMethod.getAuthenticationMethodId(), psuData);
        }
        return this.proceedEmbeddedApproach(authorisationProcessorRequest, chosenMethod.getAuthenticationMethodId(), consent, psuData);
    }

    private UpdateConsentPsuDataResponse applyIdentification(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        if (!this.isPsuExist(request.getPsuData())) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)this.getErrorType400()).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NO_PSU)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, "Apply identification when update consent PSU data has failed. No PSU data available in request.");
            return new UpdateConsentPsuDataResponse(errorHolder, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
        }
        return new UpdateConsentPsuDataResponse(ScaStatus.PSUIDENTIFIED, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
    }

    private boolean isDecoupledApproach(String authorisationId, String authenticationMethodId) {
        return this.authorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    abstract UpdateConsentPsuDataResponse proceedDecoupledApproach(String var1, String var2, T var3, String var4, PsuIdData var5);

    abstract boolean isOneFactorAuthorisation(T var1);

    abstract SpiResponse<SpiAvailableScaMethodsResponse> requestAvailableScaMethods(SpiContextData var1, T var2, SpiAspspConsentDataProvider var3);

    abstract SpiResponse<SpiPsuAuthorisationResponse> authorisePsu(SpiContextData var1, String var2, SpiPsuData var3, String var4, T var5, SpiAspspConsentDataProvider var6);

    abstract void findAndTerminateOldConsentsByNewConsentId(String var1);

    abstract void updateConsentStatus(String var1, ConsentStatus var2);

    abstract void updateMultilevelScaRequired(String var1, boolean var2);

    abstract ServiceType getServiceType();

    abstract SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(SpiContextData var1, UpdateAuthorisationRequest var2, PsuIdData var3, T var4, SpiAspspConsentDataProvider var5);

    abstract Optional<T> getConsentByIdFromCms(String var1);

    abstract ErrorType getErrorType400();

    abstract ErrorType getErrorType401();

    abstract SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(SpiContextData var1, String var2, T var3, SpiAspspConsentDataProvider var4);
}

