/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.FieldLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.consent.TransactionListBodyValidator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionListBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements TransactionListBodyValidator {
    static final String BOOKING_STATUS_PARAM = "bookingStatus";

    @Autowired
    public TransactionListBodyValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, FieldLengthValidator fieldLengthValidator) {
        super(errorBuildingService, xs2aObjectMapper, fieldLengthValidator);
    }

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        String acceptHeader = request.getHeader("Accept");
        if (StringUtils.isNotBlank((CharSequence)acceptHeader)) {
            String bookingStatus = request.getParameter(BOOKING_STATUS_PARAM);
            if (BookingStatus.INFORMATION.getValue().equals(bookingStatus) && !"application/json".equals(acceptHeader)) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.REQUESTED_FORMATS_INVALID));
            }
        }
        return messageError;
    }
}

