/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.PsuDataInInitialRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.SupportedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentRequestObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreatePiisConsentValidator
implements BusinessValidator<CreatePiisConsentRequestObject> {
    private final PsuDataInInitialRequestValidator psuDataInInitialRequestValidator;
    private final SupportedAccountReferenceValidator supportedAccountReferenceValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreatePiisConsentRequestObject requestObject) {
        ValidationResult psuDataValidationResult = this.psuDataInInitialRequestValidator.validate(requestObject.getPsuIdData());
        if (psuDataValidationResult.isNotValid()) {
            return psuDataValidationResult;
        }
        CreatePiisConsentRequest request = requestObject.getCreatePiisConsentRequest();
        ValidationResult supportedAccountReferenceValidationResult = this.supportedAccountReferenceValidator.validate((Collection<AccountReference>)Collections.singletonList(request.getAccount()));
        if (supportedAccountReferenceValidationResult.isNotValid()) {
            return supportedAccountReferenceValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"psuDataInInitialRequestValidator", "supportedAccountReferenceValidator"})
    public CreatePiisConsentValidator(PsuDataInInitialRequestValidator psuDataInInitialRequestValidator, SupportedAccountReferenceValidator supportedAccountReferenceValidator) {
        this.psuDataInInitialRequestValidator = psuDataInInitialRequestValidator;
        this.supportedAccountReferenceValidator = supportedAccountReferenceValidator;
    }
}

