/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.authorisation;

import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsentAuthorisationValidator {
    private static final Logger log = LoggerFactory.getLogger(ConsentAuthorisationValidator.class);

    @NotNull
    public ValidationResult validate(@NotNull String authorisationId, @NotNull Consent consent) {
        Optional authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (authorisationOptional.isEmpty()) {
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Authorisation validation has failed: couldn't find authorisation with given authorisationId for consent", (Object)consent.getId(), (Object)authorisationId);
            return ValidationResult.invalid((ErrorType)this.getErrorType(), (MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        return ValidationResult.valid();
    }

    protected abstract ErrorType getErrorType();
}

