/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.DownloadTransactionListRequestObject;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DownloadTransactionsReportValidator
extends AbstractAccountTppValidator<DownloadTransactionListRequestObject> {
    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(DownloadTransactionListRequestObject consentObject) {
        AisConsent aisConsent = consentObject.getAisConsent();
        if (LocalDate.now().compareTo(aisConsent.getValidUntil()) > 0) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.CONSENT_EXPIRED);
        }
        ConsentStatus consentStatus = aisConsent.getConsentStatus();
        if (consentStatus != ConsentStatus.VALID) {
            MessageErrorCode messageErrorCode = consentStatus == ConsentStatus.RECEIVED ? MessageErrorCode.CONSENT_INVALID : MessageErrorCode.CONSENT_EXPIRED;
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)messageErrorCode);
        }
        return ValidationResult.valid();
    }
}

