/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aExchangeRateMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiEntryDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiStandingOrderDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aTransactionMapperImpl
implements SpiToXs2aTransactionMapper {
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aBalanceMapper spiToXs2aBalanceMapper;
    @Autowired
    private SpiToXs2aExchangeRateMapper spiToXs2aExchangeRateMapper;
    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;

    @Override
    public Transactions mapToXs2aTransaction(SpiTransaction spiTransaction) {
        if (spiTransaction == null) {
            return null;
        }
        Transactions transactions = new Transactions();
        transactions.setAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiTransaction.getSpiAmount()));
        transactions.setTransactionId(spiTransaction.getTransactionId());
        transactions.setEntryReference(spiTransaction.getEntryReference());
        transactions.setEndToEndId(spiTransaction.getEndToEndId());
        transactions.setMandateId(spiTransaction.getMandateId());
        transactions.setCheckId(spiTransaction.getCheckId());
        transactions.setCreditorId(spiTransaction.getCreditorId());
        transactions.setBookingDate(spiTransaction.getBookingDate());
        transactions.setValueDate(spiTransaction.getValueDate());
        transactions.setExchangeRate(this.spiToXs2aExchangeRateMapper.mapToExchangeRateList(spiTransaction.getExchangeRate()));
        transactions.setCreditorName(spiTransaction.getCreditorName());
        transactions.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiTransaction.getCreditorAccount()));
        transactions.setCreditorAgent(spiTransaction.getCreditorAgent());
        transactions.setUltimateCreditor(spiTransaction.getUltimateCreditor());
        transactions.setDebtorName(spiTransaction.getDebtorName());
        transactions.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiTransaction.getDebtorAccount()));
        transactions.setDebtorAgent(spiTransaction.getDebtorAgent());
        transactions.setUltimateDebtor(spiTransaction.getUltimateDebtor());
        transactions.setRemittanceInformationUnstructured(spiTransaction.getRemittanceInformationUnstructured());
        List list1 = spiTransaction.getRemittanceInformationUnstructuredArray();
        if (list1 != null) {
            transactions.setRemittanceInformationUnstructuredArray(new ArrayList<String>(list1));
        }
        transactions.setRemittanceInformationStructured(spiTransaction.getRemittanceInformationStructured());
        List list2 = spiTransaction.getRemittanceInformationStructuredArray();
        if (list2 != null) {
            transactions.setRemittanceInformationStructuredArray(new ArrayList<String>(list2));
        }
        transactions.setProprietaryBankTransactionCode(spiTransaction.getProprietaryBankTransactionCode());
        transactions.setAdditionalInformation(spiTransaction.getAdditionalInformation());
        transactions.setAdditionalInformationStructured(this.spiAdditionalInformationStructuredToXs2aAdditionalInformationStructured(spiTransaction.getAdditionalInformationStructured()));
        transactions.setBalanceAfterTransaction(this.spiToXs2aBalanceMapper.mapToXs2aBalance(spiTransaction.getBalanceAfterTransaction()));
        transactions.setBatchIndicator(spiTransaction.getBatchIndicator());
        transactions.setBatchNumberOfTransactions(spiTransaction.getBatchNumberOfTransactions());
        transactions.setEntryDetails(this.mapToEntryDetailsList(spiTransaction.getEntryDetails()));
        transactions.setBankTransactionCodeCode(new BankTransactionCode(spiTransaction.getBankTransactionCodeCode()));
        transactions.setPurposeCode(PurposeCode.fromValue((String)spiTransaction.getPurposeCode()));
        return transactions;
    }

    @Override
    public List<Transactions> mapToXs2aTransactionList(List<SpiTransaction> spiTransactions) {
        if (spiTransactions == null) {
            return null;
        }
        ArrayList<Transactions> list = new ArrayList<Transactions>(spiTransactions.size());
        for (SpiTransaction spiTransaction : spiTransactions) {
            list.add(this.mapToXs2aTransaction(spiTransaction));
        }
        return list;
    }

    @Override
    public EntryDetails mapToEntryDetails(SpiEntryDetails spiEntryDetails) {
        if (spiEntryDetails == null) {
            return null;
        }
        EntryDetails entryDetails = new EntryDetails();
        entryDetails.setEndToEndId(spiEntryDetails.getEndToEndId());
        entryDetails.setMandateId(spiEntryDetails.getMandateId());
        entryDetails.setCheckId(spiEntryDetails.getCheckId());
        entryDetails.setCreditorId(spiEntryDetails.getCreditorId());
        entryDetails.setTransactionAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiEntryDetails.getTransactionAmount()));
        entryDetails.setCurrencyExchange(this.spiToXs2aExchangeRateMapper.mapToExchangeRateList(spiEntryDetails.getCurrencyExchange()));
        entryDetails.setCreditorName(spiEntryDetails.getCreditorName());
        entryDetails.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiEntryDetails.getCreditorAccount()));
        entryDetails.setCreditorAgent(spiEntryDetails.getCreditorAgent());
        entryDetails.setUltimateCreditor(spiEntryDetails.getUltimateCreditor());
        entryDetails.setDebtorName(spiEntryDetails.getDebtorName());
        entryDetails.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiEntryDetails.getDebtorAccount()));
        entryDetails.setDebtorAgent(spiEntryDetails.getDebtorAgent());
        entryDetails.setUltimateDebtor(spiEntryDetails.getUltimateDebtor());
        entryDetails.setRemittanceInformationUnstructured(spiEntryDetails.getRemittanceInformationUnstructured());
        List list1 = spiEntryDetails.getRemittanceInformationUnstructuredArray();
        if (list1 != null) {
            entryDetails.setRemittanceInformationUnstructuredArray(new ArrayList<String>(list1));
        }
        entryDetails.setRemittanceInformationStructured(spiEntryDetails.getRemittanceInformationStructured());
        List list2 = spiEntryDetails.getRemittanceInformationStructuredArray();
        if (list2 != null) {
            entryDetails.setRemittanceInformationStructuredArray(new ArrayList<String>(list2));
        }
        entryDetails.setPurposeCode(PurposeCode.fromValue((String)spiEntryDetails.getPurposeCode()));
        return entryDetails;
    }

    @Override
    public List<EntryDetails> mapToEntryDetailsList(List<SpiEntryDetails> spiEntryDetails) {
        if (spiEntryDetails == null) {
            return null;
        }
        ArrayList<EntryDetails> list = new ArrayList<EntryDetails>(spiEntryDetails.size());
        for (SpiEntryDetails spiEntryDetails1 : spiEntryDetails) {
            list.add(this.mapToEntryDetails(spiEntryDetails1));
        }
        return list;
    }

    protected Xs2aStandingOrderDetails spiStandingOrderDetailsToXs2aStandingOrderDetails(SpiStandingOrderDetails spiStandingOrderDetails) {
        if (spiStandingOrderDetails == null) {
            return null;
        }
        Xs2aStandingOrderDetails xs2aStandingOrderDetails = new Xs2aStandingOrderDetails();
        xs2aStandingOrderDetails.setStartDate(spiStandingOrderDetails.getStartDate());
        xs2aStandingOrderDetails.setEndDate(spiStandingOrderDetails.getEndDate());
        xs2aStandingOrderDetails.setExecutionRule(spiStandingOrderDetails.getExecutionRule());
        xs2aStandingOrderDetails.setWithinAMonthFlag(spiStandingOrderDetails.getWithinAMonthFlag());
        xs2aStandingOrderDetails.setFrequency(spiStandingOrderDetails.getFrequency());
        List list = spiStandingOrderDetails.getMonthsOfExecution();
        if (list != null) {
            xs2aStandingOrderDetails.setMonthsOfExecution(new ArrayList<String>(list));
        }
        xs2aStandingOrderDetails.setMultiplicator(spiStandingOrderDetails.getMultiplicator());
        xs2aStandingOrderDetails.setDayOfExecution(spiStandingOrderDetails.getDayOfExecution());
        xs2aStandingOrderDetails.setLimitAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiStandingOrderDetails.getLimitAmount()));
        return xs2aStandingOrderDetails;
    }

    protected Xs2aAdditionalInformationStructured spiAdditionalInformationStructuredToXs2aAdditionalInformationStructured(SpiAdditionalInformationStructured spiAdditionalInformationStructured) {
        if (spiAdditionalInformationStructured == null) {
            return null;
        }
        Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured = new Xs2aAdditionalInformationStructured();
        xs2aAdditionalInformationStructured.setStandingOrderDetails(this.spiStandingOrderDetailsToXs2aStandingOrderDetails(spiAdditionalInformationStructured.getStandingOrderDetails()));
        return xs2aAdditionalInformationStructured;
    }
}

