/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.ais;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error500.Error500NGAIS;
import de.adorsys.psd2.xs2a.exception.model.error500.TppMessage500AIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AIS500ErrorMapper
extends Psd2ErrorMapper<MessageError, Error500NGAIS> {
    @Override
    public Function<MessageError, Error500NGAIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Error500NGAIS mapToPsd2Error(MessageError messageError) {
        return ((Error500NGAIS.Error500NGAISBuilder)Error500NGAIS.builder().tppMessages(this.mapToTppMessage500AIS(messageError.getTppMessages()))).build();
    }

    private List<TppMessage500AIS> mapToTppMessage500AIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> ((TppMessage500AIS.TppMessage500AISBuilder)((TppMessage500AIS.TppMessage500AISBuilder)((TppMessage500AIS.TppMessage500AISBuilder)((TppMessage500AIS.TppMessage500AISBuilder)TppMessage500AIS.builder().category(TppMessageCategory.fromValue((String)m.getCategory().name()))).code(m.getMessageErrorCode().getName())).path(m.getPath())).text(this.getErrorText((TppMessageInformation)m))).build()).collect(Collectors.toList());
    }
}

