/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.PaymentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaymentServiceForAuthorisation {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceForAuthorisation.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final RequestProviderService requestProviderService;

    public ResponseObject<Xs2aScaStatusResponse> getAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        SpiAspspConsentDataProvider spiAspspConsentDataProvider;
        ResponseObject<PaymentScaStatus> paymentScaStatusResponse = this.getCMSScaStatus(paymentId, authorisationId, paymentType, paymentProduct);
        if (paymentScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(paymentScaStatusResponse.getError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiResponse<SpiScaStatusResponse> spiScaStatusResponse = this.getScaStatus(contextData, authorisationId, spiAspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId));
        if (spiScaStatusResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiScaStatusResponse, ServiceType.PIS);
            log.info("Authorisation-ID [{}], Payment-ID [{}]. Get SCA status failed.", (Object)authorisationId, (Object)paymentId);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        SpiScaStatusResponse spiScaStatus = (SpiScaStatusResponse)spiScaStatusResponse.getPayload();
        ScaStatus scaStatus = paymentScaStatusResponse.getBody().getScaStatus();
        Boolean beneficiaryFlag = scaStatus.isFinalisedStatus() ? spiScaStatus.getTrustedBeneficiaryFlag() : null;
        Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(scaStatus, beneficiaryFlag, spiScaStatus.getPsuMessage());
        return ResponseObject.builder().body(response).build();
    }

    abstract ResponseObject<PaymentScaStatus> getCMSScaStatus(String var1, String var2, PaymentType var3, String var4);

    abstract SpiResponse<SpiScaStatusResponse> getScaStatus(@NotNull SpiContextData var1, @NotNull String var2, @NotNull SpiAspspConsentDataProvider var3);

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    @ConstructorProperties(value={"spiContextDataProvider", "aspspConsentDataProviderFactory", "spiErrorMapper", "requestProviderService"})
    public PaymentServiceForAuthorisation(SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, RequestProviderService requestProviderService) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.requestProviderService = requestProviderService;
    }
}

