/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aPaymentMapperImpl
implements SpiToXs2aPaymentMapper {
    @Override
    public SinglePaymentInitiationResponse mapToPaymentInitiateResponse(SpiSinglePaymentInitiationResponse spi, InitialSpiAspspConsentDataProvider aspspConsentDataProvider) {
        SinglePaymentInitiationResponse singlePaymentInitiationResponse = new SinglePaymentInitiationResponse();
        if (spi != null) {
            singlePaymentInitiationResponse.setTransactionFeeIndicator(spi.getSpiTransactionFeeIndicator());
            singlePaymentInitiationResponse.setTransactionStatus(spi.getTransactionStatus());
            singlePaymentInitiationResponse.setMultilevelScaRequired(spi.isMultilevelScaRequired());
            singlePaymentInitiationResponse.setPaymentId(spi.getPaymentId());
            singlePaymentInitiationResponse.setChallengeData(spi.getChallengeData());
            singlePaymentInitiationResponse.setAspspAccountId(spi.getAspspAccountId());
            singlePaymentInitiationResponse.setCurrencyConversionFee(this.spiAmountToXs2aAmount(spi.getCurrencyConversionFee()));
            singlePaymentInitiationResponse.setEstimatedTotalAmount(this.spiAmountToXs2aAmount(spi.getEstimatedTotalAmount()));
            singlePaymentInitiationResponse.setEstimatedInterbankSettlementAmount(this.spiAmountToXs2aAmount(spi.getEstimatedInterbankSettlementAmount()));
        }
        if (aspspConsentDataProvider != null) {
            singlePaymentInitiationResponse.setAspspConsentDataProvider(aspspConsentDataProvider);
        }
        return singlePaymentInitiationResponse;
    }

    @Override
    public PeriodicPaymentInitiationResponse mapToPaymentInitiateResponse(SpiPeriodicPaymentInitiationResponse spi, InitialSpiAspspConsentDataProvider aspspConsentDataProvider) {
        PeriodicPaymentInitiationResponse periodicPaymentInitiationResponse = new PeriodicPaymentInitiationResponse();
        if (spi != null) {
            periodicPaymentInitiationResponse.setTransactionFeeIndicator(spi.getSpiTransactionFeeIndicator());
            periodicPaymentInitiationResponse.setTransactionStatus(spi.getTransactionStatus());
            periodicPaymentInitiationResponse.setMultilevelScaRequired(spi.isMultilevelScaRequired());
            periodicPaymentInitiationResponse.setPaymentId(spi.getPaymentId());
            periodicPaymentInitiationResponse.setChallengeData(spi.getChallengeData());
            periodicPaymentInitiationResponse.setAspspAccountId(spi.getAspspAccountId());
            periodicPaymentInitiationResponse.setCurrencyConversionFee(this.spiAmountToXs2aAmount(spi.getCurrencyConversionFee()));
            periodicPaymentInitiationResponse.setEstimatedTotalAmount(this.spiAmountToXs2aAmount(spi.getEstimatedTotalAmount()));
            periodicPaymentInitiationResponse.setEstimatedInterbankSettlementAmount(this.spiAmountToXs2aAmount(spi.getEstimatedInterbankSettlementAmount()));
        }
        if (aspspConsentDataProvider != null) {
            periodicPaymentInitiationResponse.setAspspConsentDataProvider(aspspConsentDataProvider);
        }
        return periodicPaymentInitiationResponse;
    }

    @Override
    public BulkPaymentInitiationResponse mapToPaymentInitiateResponse(SpiBulkPaymentInitiationResponse spi, InitialSpiAspspConsentDataProvider aspspConsentDataProvider) {
        BulkPaymentInitiationResponse bulkPaymentInitiationResponse = new BulkPaymentInitiationResponse();
        if (spi != null) {
            bulkPaymentInitiationResponse.setTransactionFeeIndicator(spi.getSpiTransactionFeeIndicator());
            bulkPaymentInitiationResponse.setTransactionStatus(spi.getTransactionStatus());
            bulkPaymentInitiationResponse.setMultilevelScaRequired(spi.isMultilevelScaRequired());
            bulkPaymentInitiationResponse.setPaymentId(spi.getPaymentId());
            bulkPaymentInitiationResponse.setChallengeData(spi.getChallengeData());
            bulkPaymentInitiationResponse.setAspspAccountId(spi.getAspspAccountId());
            bulkPaymentInitiationResponse.setCurrencyConversionFee(this.spiAmountToXs2aAmount(spi.getCurrencyConversionFee()));
            bulkPaymentInitiationResponse.setEstimatedTotalAmount(this.spiAmountToXs2aAmount(spi.getEstimatedTotalAmount()));
            bulkPaymentInitiationResponse.setEstimatedInterbankSettlementAmount(this.spiAmountToXs2aAmount(spi.getEstimatedInterbankSettlementAmount()));
        }
        if (aspspConsentDataProvider != null) {
            bulkPaymentInitiationResponse.setAspspConsentDataProvider(aspspConsentDataProvider);
        }
        return bulkPaymentInitiationResponse;
    }

    @Override
    public CommonPaymentInitiationResponse mapToCommonPaymentInitiateResponse(SpiPaymentInitiationResponse spi, PaymentType type, InitialSpiAspspConsentDataProvider aspspConsentDataProvider) {
        CommonPaymentInitiationResponse commonPaymentInitiationResponse = new CommonPaymentInitiationResponse();
        if (spi != null) {
            commonPaymentInitiationResponse.setTransactionFeeIndicator(spi.getSpiTransactionFeeIndicator());
            commonPaymentInitiationResponse.setTransactionStatus(spi.getTransactionStatus());
            commonPaymentInitiationResponse.setMultilevelScaRequired(spi.isMultilevelScaRequired());
            commonPaymentInitiationResponse.setPaymentId(spi.getPaymentId());
            commonPaymentInitiationResponse.setChallengeData(spi.getChallengeData());
            commonPaymentInitiationResponse.setAspspAccountId(spi.getAspspAccountId());
            commonPaymentInitiationResponse.setCurrencyConversionFee(this.spiAmountToXs2aAmount(spi.getCurrencyConversionFee()));
            commonPaymentInitiationResponse.setEstimatedTotalAmount(this.spiAmountToXs2aAmount(spi.getEstimatedTotalAmount()));
            commonPaymentInitiationResponse.setEstimatedInterbankSettlementAmount(this.spiAmountToXs2aAmount(spi.getEstimatedInterbankSettlementAmount()));
        }
        if (type != null) {
            commonPaymentInitiationResponse.setPaymentType(type);
        }
        if (aspspConsentDataProvider != null) {
            commonPaymentInitiationResponse.setAspspConsentDataProvider(aspspConsentDataProvider);
        }
        return commonPaymentInitiationResponse;
    }

    @Override
    public Xs2aAmount spiAmountToXs2aAmount(SpiAmount spiAmount) {
        if (spiAmount == null) {
            return null;
        }
        Xs2aAmount xs2aAmount = new Xs2aAmount();
        xs2aAmount.setCurrency(spiAmount.getCurrency());
        if (spiAmount.getAmount() != null) {
            xs2aAmount.setAmount(spiAmount.getAmount().toString());
        }
        return xs2aAmount;
    }
}

