/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2;

import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.web.error.ServiceUnavailableError;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class ResponseErrorMapper {
    private static final Logger log = LoggerFactory.getLogger(ResponseErrorMapper.class);
    private static final String LOG_PATTERN = "Generate error: [{}]";
    private final ErrorMapperContainer errorMapperContainer;

    public ResponseEntity generateErrorResponse(MessageError error) {
        ErrorMapperContainer.ErrorBody errorBody = this.errorMapperContainer.getErrorBody(error);
        log.info(LOG_PATTERN, (Object)error);
        return new ResponseEntity(errorBody.getBody(), errorBody.getStatus());
    }

    public ResponseEntity generateErrorResponse(MessageError error, ResponseHeaders responseHeaders) {
        ErrorMapperContainer.ErrorBody errorBody = this.errorMapperContainer.getErrorBody(error);
        log.info(LOG_PATTERN, (Object)error);
        return new ResponseEntity(errorBody.getBody(), (MultiValueMap)responseHeaders.getHttpHeaders(), errorBody.getStatus());
    }

    public ResponseEntity generateServiceUnavailableErrorResponse(String error) {
        log.info(LOG_PATTERN, (Object)error);
        return new ResponseEntity((Object)new ServiceUnavailableError(), HttpStatus.SERVICE_UNAVAILABLE);
    }

    @ConstructorProperties(value={"errorMapperContainer"})
    public ResponseErrorMapper(ErrorMapperContainer errorMapperContainer) {
        this.errorMapperContainer = errorMapperContainer;
    }
}

