/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.ConsentAuthorization;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class Xs2aAccountConsentAuthorizationMapper {
    List<ConsentAuthorization> mapToAccountConsentAuthorisation(List<Authorisation> authorisations) {
        if (CollectionUtils.isEmpty(authorisations)) {
            return Collections.emptyList();
        }
        return authorisations.stream().map(this::mapToAccountConsentAuthorisation).collect(Collectors.toList());
    }

    private ConsentAuthorization mapToAccountConsentAuthorisation(Authorisation authorisation) {
        return Optional.ofNullable(authorisation).map(auth -> {
            ConsentAuthorization accountConsentAuthorisation = new ConsentAuthorization();
            accountConsentAuthorisation.setId(auth.getAuthorisationId());
            accountConsentAuthorisation.setConsentId(auth.getParentId());
            accountConsentAuthorisation.setPsuIdData(auth.getPsuIdData());
            accountConsentAuthorisation.setScaStatus(auth.getScaStatus());
            accountConsentAuthorisation.setPassword(auth.getPassword());
            accountConsentAuthorisation.setChosenScaApproach(auth.getChosenScaApproach());
            accountConsentAuthorisation.setAuthenticationMethodId(auth.getAuthenticationMethodId());
            accountConsentAuthorisation.setScaAuthenticationData(auth.getScaAuthenticationData());
            return accountConsentAuthorisation;
        }).orElse(null);
    }
}

