/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.CardAccountHandler;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAccountService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiCardTransactionListToXs2aAccountReportMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetCardTransactionsReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CardTransactionsReportByPeriodObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReportParameters;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CardAccountSpi;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardTransactionService {
    private static final Logger log = LoggerFactory.getLogger(CardTransactionService.class);
    private final CardAccountSpi cardAccountSpi;
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiCardTransactionListToXs2aAccountReportMapper cardTransactionListToXs2aAccountReportMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAccountService xs2aAccountService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetCardTransactionsReportValidator getCardTransactionsReportValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;
    private final CardAccountHandler cardAccountHandler;

    public ResponseObject<Xs2aCardTransactionsReport> getCardTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request) {
        this.xs2aEventService.recordConsentTppRequest(request.getConsentId(), EventType.READ_CARD_TRANSACTION_LIST_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(request.getConsentId());
        if (aisConsentOptional.isEmpty()) {
            log.info("Account-ID [{}], Consent-ID [{}]. Get card transactions report by period failed. Account consent not found by ID", (Object)request.getAccountId(), (Object)request.getConsentId());
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForTransactionsReportByPeriod(request, aisConsent);
        if (validationResult.isNotValid()) {
            log.info("Account-ID [{}], Consent-ID [{}], WithBalance [{}], RequestUri [{}]. Get transactions report by period - validation failed: {}", new Object[]{request.getAccountId(), request.getConsentId(), request.isWithBalance(), request.getRequestUri(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiCardTransactionReport> spiResponse = this.getSpiResponseSpiCardTransactionReport(request, aisConsent);
        if (spiResponse.hasError()) {
            return this.checkSpiResponseForCardTransactionsReport(request, spiResponse);
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        this.xs2aAccountService.saveNumberOfTransaction(request.getConsentId(), request.getAccountId(), ((SpiCardTransactionReport)spiResponse.getPayload()).getCardTransactions().size());
        return this.getXs2aCardTransactionsReportResponseObject(request, aisConsent, (SpiCardTransactionReport)spiResponse.getPayload());
    }

    private ValidationResult getValidationResultForTransactionsReportByPeriod(Xs2aTransactionsReportByPeriodRequest request, AisConsent aisConsent) {
        CardTransactionsReportByPeriodObject validatorObject = new CardTransactionsReportByPeriodObject(aisConsent, request.getAccountId(), request.getRequestUri(), request.getDeltaList(), request.getAcceptHeader(), request.getBookingStatus(), request.getDateFrom(), request.getDateTo());
        return this.getCardTransactionsReportValidator.validate(validatorObject);
    }

    @NotNull
    private SpiResponse<SpiCardTransactionReport> getSpiResponseSpiCardTransactionReport(Xs2aTransactionsReportByPeriodRequest request, AisConsent aisConsent) {
        return this.cardAccountSpi.requestCardTransactionsForAccount(this.accountHelperService.getSpiContextData(), this.buildSpiTransactionReportParameters(request), this.getRequestedAccountReference(aisConsent, request.getAccountId()), this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getConsentId()));
    }

    private SpiTransactionReportParameters buildSpiTransactionReportParameters(Xs2aTransactionsReportByPeriodRequest request) {
        boolean isTransactionsShouldContainBalances = !this.aspspProfileService.isTransactionsWithoutBalancesSupported() || request.isWithBalance();
        return new SpiTransactionReportParameters(request.getAcceptHeader(), isTransactionsShouldContainBalances, request.getDateFrom(), request.getDateTo(), request.getBookingStatus(), request.getEntryReferenceFrom(), request.getDeltaList(), null, null);
    }

    private SpiAccountReference getRequestedAccountReference(AisConsent aisConsent, String accountId) {
        AccountAccess access = aisConsent.getAspspAccountAccesses();
        return this.accountHelperService.findAccountReference(access.getTransactions(), accountId);
    }

    private ResponseObject<Xs2aCardTransactionsReport> checkSpiResponseForCardTransactionsReport(Xs2aTransactionsReportByPeriodRequest request, SpiResponse<SpiCardTransactionReport> spiResponse) {
        if (((TppMessage)spiResponse.getErrors().get(0)).getErrorCode() == MessageErrorCode.SERVICE_NOT_SUPPORTED) {
            log.info("Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: requested content-type not json or text.", (Object)request.getAccountId(), (Object)request.getConsentId());
            return ResponseObject.builder().fail(ErrorType.AIS_406, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.REQUESTED_FORMATS_INVALID)).build();
        }
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("Account-ID [{}], Consent-ID: [{}]. Get transactions report by period failed: Request transactions for account fail at SPI level: {}", new Object[]{request.getAccountId(), request.getConsentId(), errorHolder});
        return ResponseObject.builder().fail(errorHolder).build();
    }

    @NotNull
    private ResponseObject<Xs2aCardTransactionsReport> getXs2aCardTransactionsReportResponseObject(Xs2aTransactionsReportByPeriodRequest request, AisConsent aisConsent, SpiCardTransactionReport spiTransactionReport) {
        Xs2aCardTransactionsReport transactionsReport = this.mapToCardTransactionsReport(request, aisConsent, spiTransactionReport);
        ResponseObject<Xs2aCardTransactionsReport> response = ResponseObject.builder().body(transactionsReport).build();
        AccountReference accountReference = transactionsReport.getAccountReference();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), request.getConsentId(), this.accountHelperService.createActionStatus(request.isWithBalance(), TypeAccess.TRANSACTION, response), request.getRequestUri(), this.accountHelperService.needsToUpdateUsage(aisConsent), accountReference == null ? null : accountReference.getResourceId(), null);
        return response;
    }

    @NotNull
    private Xs2aCardTransactionsReport mapToCardTransactionsReport(Xs2aTransactionsReportByPeriodRequest request, AisConsent accountConsent, SpiCardTransactionReport spiTransactionReport) {
        Xs2aCardAccountReport report = this.cardTransactionListToXs2aAccountReportMapper.mapToXs2aCardAccountReport(request.getBookingStatus(), spiTransactionReport.getCardTransactions(), spiTransactionReport.getTransactionsRaw()).orElse(null);
        Xs2aCardTransactionsReport cardTransactionsReport = this.getXs2aCardTransactionsReport(report, this.filterAccountReference(accountConsent.getAccess().getTransactions(), request.getAccountId()), spiTransactionReport);
        if (spiTransactionReport.getDownloadId() != null) {
            String encodedDownloadId = Base64.getUrlEncoder().encodeToString(spiTransactionReport.getDownloadId().getBytes());
            cardTransactionsReport.setDownloadId(encodedDownloadId);
        }
        return cardTransactionsReport;
    }

    private Xs2aCardTransactionsReport getXs2aCardTransactionsReport(Xs2aCardAccountReport report, AccountReference requestedAccountReference, SpiCardTransactionReport spiCardTransactionReport) {
        Xs2aCardTransactionsReport transactionsReport = new Xs2aCardTransactionsReport();
        transactionsReport.setCardAccountReport(report);
        transactionsReport.setAccountReference(this.getMaskedAccountReference(requestedAccountReference));
        transactionsReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(spiCardTransactionReport.getBalances()));
        transactionsReport.setResponseContentType(spiCardTransactionReport.getResponseContentType());
        return transactionsReport;
    }

    private AccountReference getMaskedAccountReference(AccountReference filteredAccountReference) {
        if (filteredAccountReference != null && StringUtils.isNotBlank((CharSequence)filteredAccountReference.getPan())) {
            String maskedPan = this.cardAccountHandler.hidePanInAccountReference(filteredAccountReference.getPan());
            filteredAccountReference.setPan(null);
            filteredAccountReference.setMaskedPan(maskedPan);
        }
        return filteredAccountReference;
    }

    private AccountReference filterAccountReference(List<AccountReference> references, String resourceId) {
        if (references == null) {
            return null;
        }
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"cardAccountSpi", "balanceMapper", "cardTransactionListToXs2aAccountReportMapper", "aisConsentService", "xs2aAccountService", "consentMapper", "tppService", "aspspProfileService", "xs2aEventService", "spiErrorMapper", "getCardTransactionsReportValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService", "cardAccountHandler"})
    public CardTransactionService(CardAccountSpi cardAccountSpi, SpiToXs2aBalanceMapper balanceMapper, SpiCardTransactionListToXs2aAccountReportMapper cardTransactionListToXs2aAccountReportMapper, Xs2aAisConsentService aisConsentService, Xs2aAccountService xs2aAccountService, Xs2aAisConsentMapper consentMapper, TppService tppService, AspspProfileServiceWrapper aspspProfileService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetCardTransactionsReportValidator getCardTransactionsReportValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService, CardAccountHandler cardAccountHandler) {
        this.cardAccountSpi = cardAccountSpi;
        this.balanceMapper = balanceMapper;
        this.cardTransactionListToXs2aAccountReportMapper = cardTransactionListToXs2aAccountReportMapper;
        this.aisConsentService = aisConsentService;
        this.xs2aAccountService = xs2aAccountService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.aspspProfileService = aspspProfileService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getCardTransactionsReportValidator = getCardTransactionsReportValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
        this.cardAccountHandler = cardAccountHandler;
    }
}

