/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.PaymentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaymentServiceForAuthorisation {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceForAuthorisation.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper;

    public ResponseObject<Xs2aScaStatusResponse> getAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        ResponseObject<PaymentScaStatus> paymentScaStatusResponse = this.getPaymentScaStatus(paymentId, authorisationId, paymentType, paymentProduct);
        if (paymentScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(paymentScaStatusResponse.getError()).build();
        }
        PaymentScaStatus paymentScaStatus = paymentScaStatusResponse.getBody();
        ScaStatus scaStatus = paymentScaStatus.getScaStatus();
        if (scaStatus.isNotFinalisedStatus()) {
            Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(scaStatus, null);
            return ResponseObject.builder().body(response).build();
        }
        ResponseObject<Boolean> beneficiaryFlagResponse = this.getTrustedBeneficiaryFlag(paymentScaStatus.getPsuIdData(), paymentId, authorisationId, paymentScaStatus.getPisCommonPaymentResponse());
        if (beneficiaryFlagResponse.hasError()) {
            return ResponseObject.builder().fail(beneficiaryFlagResponse.getError()).build();
        }
        Boolean beneficiaryFlag = beneficiaryFlagResponse.getBody();
        Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(scaStatus, beneficiaryFlag);
        return ResponseObject.builder().body(response).build();
    }

    abstract ResponseObject<PaymentScaStatus> getPaymentScaStatus(String var1, String var2, PaymentType var3, String var4);

    abstract SpiResponse<Boolean> getTrustedBeneficiaryFlagFromSpi(SpiContextData var1, SpiPayment var2, String var3, SpiAspspConsentDataProvider var4);

    private ResponseObject<Boolean> getTrustedBeneficiaryFlag(PsuIdData psuIdData, String paymentId, String authorisationId, PisCommonPaymentResponse pisCommonPaymentResponse) {
        SpiPayment spiPayment = this.xs2aToSpiPaymentMapper.mapToSpiPayment(pisCommonPaymentResponse);
        SpiResponse<Boolean> spiResponse = this.getTrustedBeneficiaryFlagFromSpi(this.spiContextDataProvider.provideWithPsuIdData(psuIdData), spiPayment, authorisationId, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("Authorisation-ID [{}], Payment-ID [{}]. Get trusted beneficiaries flag failed.", (Object)authorisationId, (Object)paymentId);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        return ResponseObject.builder().body((Boolean)spiResponse.getPayload()).build();
    }

    @ConstructorProperties(value={"spiContextDataProvider", "aspspConsentDataProviderFactory", "spiErrorMapper", "xs2aToSpiPaymentMapper"})
    public PaymentServiceForAuthorisation(SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentMapper = xs2aToSpiPaymentMapper;
    }
}

