/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.adorsys.psd2.model.DayOfExecution;
import java.io.IOException;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayOfExecutionDeserializer
extends StdDeserializer<DayOfExecution> {
    private static final Logger log = LoggerFactory.getLogger(DayOfExecutionDeserializer.class);

    public DayOfExecutionDeserializer() {
        super(DayOfExecution.class);
    }

    public DayOfExecution deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            String date = jsonParser.getText();
            return DayOfExecution.fromValue((String)date.replaceFirst("^0+(?!$)", ""));
        }
        catch (IOException | DateTimeParseException e) {
            log.error("Unsupported dayOfExecution format!");
            return null;
        }
    }
}

