/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PsuDeviceIdHeaderValidatorImpl
extends AbstractHeaderValidatorImpl
implements ConsentHeaderValidator,
PaymentHeaderValidator {
    private static final String UUID_REGEX = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}\\z";
    private static final Pattern PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}\\z", 2);

    @Autowired
    public PsuDeviceIdHeaderValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return "psu-device-id";
    }

    @Override
    protected ValidationResult checkHeaderContent(Map<String, String> headers) {
        String header = headers.get(this.getHeaderName());
        if (this.isNonValid(header)) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_HEADER, (Object[])new Object[]{this.getHeaderName()}));
        }
        return super.checkHeaderContent(headers);
    }

    private boolean isNonValid(String psuDeviceId) {
        return !PATTERN.matcher(psuDeviceId).matches();
    }

    @Override
    public ValidationResult validate(Map<String, String> headers) {
        if (StringUtils.isBlank((CharSequence)headers.get(this.getHeaderName()))) {
            return ValidationResult.valid();
        }
        return this.checkHeaderContent(headers);
    }
}

