/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.NotificationModeResponseHeaders;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.service.ConsentService;
import de.adorsys.psd2.xs2a.service.NotificationSupportedModeService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.web.header.ConsentHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConsentController
implements ConsentApi {
    private static final Logger log = LoggerFactory.getLogger(ConsentController.class);
    private final ConsentService consentService;
    private final ResponseMapper responseMapper;
    private final ConsentModelMapper consentModelMapper;
    private final AuthorisationMapper authorisationMapper;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final ResponseErrorMapper responseErrorMapper;
    private final ConsentHeadersBuilder consentHeadersBuilder;
    private final NotificationSupportedModeService notificationSupportedModeService;
    private final RequestProviderService requestProviderService;

    public ResponseEntity createConsent(UUID xRequestID, String psuIpAddress, Consents body, String digest, String signature, byte[] tppSignatureCertificate, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, Boolean tppRedirectPreferred, String tppRedirectUri, String tppNokRedirectUri, Boolean tppExplicitAuthorisationPreferred, String tppBrandLoggingInformation, String tppNotificationUri, String tppNotificationContentPreferred, String psuIpPort, String psuAccept, String psuAcceptCharset, String psuAcceptEncoding, String psuAcceptLanguage, String psuUserAgent, String psuHttpMethod, UUID psuDeviceId, String psuGeoLocation) {
        PsuIdData psuData;
        TppNotificationData tppNotificationData;
        TppRedirectUri xs2aTppRedirectUri = this.tppRedirectUriMapper.mapToTppRedirectUri(tppRedirectUri, tppNokRedirectUri);
        CreateConsentReq createConsent = this.consentModelMapper.mapToCreateConsentReq(body, xs2aTppRedirectUri, tppNotificationData = this.notificationSupportedModeService.getTppNotificationData(tppNotificationContentPreferred, tppNotificationUri), tppBrandLoggingInformation, this.requestProviderService.getInstanceId());
        ResponseObject<CreateConsentResponse> createResponse = this.consentService.createAccountConsentsWithResponse(createConsent, psuData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, psuIpAddress, new AdditionalPsuIdData(psuIpPort, psuUserAgent, psuGeoLocation, psuAccept, psuAcceptCharset, psuAcceptEncoding, psuAcceptLanguage, psuHttpMethod, psuDeviceId)), BooleanUtils.isTrue((Boolean)tppExplicitAuthorisationPreferred));
        if (createResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(createResponse.getError());
        }
        CreateConsentResponse createConsentResponse = createResponse.getBody();
        NotificationModeResponseHeaders notificationHeaders = this.notificationSupportedModeService.resolveNotificationHeaders(createConsentResponse.getTppNotificationContentPreferred());
        ResponseHeaders headers = this.consentHeadersBuilder.buildCreateConsentHeaders(createConsentResponse.getAuthorizationId(), Optional.ofNullable(createConsentResponse.getLinks().getSelf()).map(HrefType::getHref).orElseThrow(() -> new IllegalArgumentException("Wrong href type in self link")), notificationHeaders);
        return this.responseMapper.created(createResponse, this.consentModelMapper::mapToConsentsResponse201, headers);
    }

    public ResponseEntity getConsentStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ConsentStatusResponse> accountConsentsStatusByIdResponse = this.consentService.getAccountConsentsStatusById(consentId);
        return accountConsentsStatusByIdResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(accountConsentsStatusByIdResponse.getError()) : this.responseMapper.ok(accountConsentsStatusByIdResponse, this.consentModelMapper::mapToConsentStatusResponse200);
    }

    public ResponseEntity startConsentAuthorisation(UUID xRequestID, String consentId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        String password = this.authorisationMapper.mapToPasswordFromBody((Map)body);
        ResponseObject<AuthorisationResponse> createResponse = this.consentService.createAisAuthorisation(psuData, consentId, password);
        if (createResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(createResponse.getError());
        }
        AuthorisationResponse authorisationResponse = createResponse.getBody();
        ResponseHeaders responseHeaders = this.consentHeadersBuilder.buildStartAuthorisationHeaders(authorisationResponse.getAuthorisationId());
        return this.responseMapper.created(ResponseObject.builder().body(this.authorisationMapper.mapToConsentCreateOrUpdateAuthorisationResponse(createResponse)).build(), responseHeaders);
    }

    public ResponseEntity updateConsentsPsuData(UUID xRequestID, String consentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String psuId, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(psuId, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress);
        return this.updateAisAuthorisation(psuData, authorisationId, consentId, body);
    }

    private ResponseEntity updateAisAuthorisation(PsuIdData psuData, String authorisationId, String consentId, Object body) {
        UpdateConsentPsuDataReq updatePsuDataRequest = this.consentModelMapper.mapToUpdatePsuData(psuData, consentId, authorisationId, (Map)body);
        ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuDataResponse = this.consentService.updateConsentPsuData(updatePsuDataRequest);
        if (updateConsentPsuDataResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(updateConsentPsuDataResponse.getError());
        }
        ResponseHeaders responseHeaders = this.consentHeadersBuilder.buildUpdatePsuDataHeaders(authorisationId);
        return this.responseMapper.ok(updateConsentPsuDataResponse, this.authorisationMapper::mapToConsentUpdatePsuAuthenticationResponse, responseHeaders);
    }

    public ResponseEntity getConsentScaStatus(String consentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aScaStatusResponse> consentAuthorisationScaStatusResponse = this.consentService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        return consentAuthorisationScaStatusResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentAuthorisationScaStatusResponse.getError()) : this.responseMapper.ok(consentAuthorisationScaStatusResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity getConsentAuthorisation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAuthorisationSubResources> consentInitiationAuthorisationsResponse = this.consentService.getConsentInitiationAuthorisations(consentId);
        return consentInitiationAuthorisationsResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentInitiationAuthorisationsResponse.getError()) : this.responseMapper.ok(consentInitiationAuthorisationsResponse, this.authorisationMapper::mapToAuthorisations);
    }

    public ResponseEntity getConsentInformation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<AisConsent> accountConsentByIdResponse = this.consentService.getAccountConsentById(consentId);
        return accountConsentByIdResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(accountConsentByIdResponse.getError()) : this.responseMapper.ok(accountConsentByIdResponse, this.consentModelMapper::mapToConsentInformationResponse200Json);
    }

    public ResponseEntity deleteConsent(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Void> response = this.consentService.deleteAccountConsentsById(consentId);
        return response.hasError() ? this.responseErrorMapper.generateErrorResponse(response.getError()) : this.responseMapper.delete(response);
    }

    @ConstructorProperties(value={"consentService", "responseMapper", "consentModelMapper", "authorisationMapper", "tppRedirectUriMapper", "responseErrorMapper", "consentHeadersBuilder", "notificationSupportedModeService", "requestProviderService"})
    public ConsentController(ConsentService consentService, ResponseMapper responseMapper, ConsentModelMapper consentModelMapper, AuthorisationMapper authorisationMapper, TppRedirectUriMapper tppRedirectUriMapper, ResponseErrorMapper responseErrorMapper, ConsentHeadersBuilder consentHeadersBuilder, NotificationSupportedModeService notificationSupportedModeService, RequestProviderService requestProviderService) {
        this.consentService = consentService;
        this.responseMapper = responseMapper;
        this.consentModelMapper = consentModelMapper;
        this.authorisationMapper = authorisationMapper;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.responseErrorMapper = responseErrorMapper;
        this.consentHeadersBuilder = consentHeadersBuilder;
        this.notificationSupportedModeService = notificationSupportedModeService;
        this.requestProviderService = requestProviderService;
    }
}

