/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfirmationOfFundsAuthorisationValidator {
    private static final Logger log = LoggerFactory.getLogger(ConfirmationOfFundsAuthorisationValidator.class);

    @NotNull
    public ValidationResult validate(@NotNull String authorisationId, @NotNull PiisConsent consent) {
        Optional authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (authorisationOptional.isEmpty()) {
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Authorisation validation has failed: couldn't find authorisation with given authorisationId for consent", (Object)consent.getId(), (Object)authorisationId);
            return ValidationResult.invalid(ErrorType.PIIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        return ValidationResult.valid();
    }
}

