/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisPsuDataService {
    private static final Logger log = LoggerFactory.getLogger(PisPsuDataService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;

    public List<PsuIdData> getPsuDataByPaymentId(String paymentId) {
        CmsResponse cmsResponse = this.pisCommonPaymentServiceEncrypted.getPsuDataListByPaymentId(paymentId);
        if (cmsResponse.hasError()) {
            log.info("Payment-ID [{}]. Can't get PsuData by payment ID because PsuData list not found by id at cms.", (Object)paymentId);
            return Collections.emptyList();
        }
        return (List)cmsResponse.getPayload();
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted"})
    public PisPsuDataService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
    }
}

