/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.validator;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import de.adorsys.psd2.xs2a.web.Psd2PaymentMethodNameConstant;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.path.PaymentTypeAndProductValidator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PaymentParametersValidationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(PaymentParametersValidationInterceptor.class);
    private static final String PAYMENT_SERVICE = "payment-service";
    private static final String PAYMENT_PRODUCT = "payment-product";
    private final ErrorBuildingService errorBuildingService;
    private final PathParameterExtractor pathParameterExtractor;
    private final PaymentTypeAndProductValidator paymentTypeAndProductValidator;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValid(request, response, handler);
    }

    private boolean isRequestValid(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String methodName = handlerMethod.getMethod().getName();
            boolean paymentRequest = Arrays.stream(Psd2PaymentMethodNameConstant.values()).anyMatch(mn -> mn.getValue().equals(methodName));
            if (paymentRequest) {
                return this.isPaymentRequestValid(request, response);
            }
        }
        return true;
    }

    private boolean isPaymentRequestValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ValidationResult validationResult;
        Map<String, String> pathParameters = this.pathParameterExtractor.extractParameters(request);
        String paymentTypeString = pathParameters.get(PAYMENT_SERVICE);
        Optional paymentTypeOptional = Optional.ofNullable(paymentTypeString).flatMap(PaymentType::getByValue);
        if (paymentTypeOptional.isEmpty()) {
            MessageError messageError = new MessageError(ErrorType.PIS_400, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_WRONG_PAYMENT_TYPE, (Object[])new Object[]{paymentTypeString})});
            this.errorBuildingService.buildPaymentErrorResponse(response, messageError);
            return false;
        }
        String paymentProduct = pathParameters.get(PAYMENT_PRODUCT);
        if (paymentProduct != null && (validationResult = this.paymentTypeAndProductValidator.validateTypeAndProduct((PaymentType)paymentTypeOptional.get(), paymentProduct)).isNotValid()) {
            this.errorBuildingService.buildPaymentErrorResponse(response, validationResult.getMessageError());
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"errorBuildingService", "pathParameterExtractor", "paymentTypeAndProductValidator"})
    public PaymentParametersValidationInterceptor(ErrorBuildingService errorBuildingService, PathParameterExtractor pathParameterExtractor, PaymentTypeAndProductValidator paymentTypeAndProductValidator) {
        this.errorBuildingService = errorBuildingService;
        this.pathParameterExtractor = pathParameterExtractor;
        this.paymentTypeAndProductValidator = paymentTypeAndProductValidator;
    }
}

