/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountReferenceAccessValidator {
    public ValidationResult validate(AisConsent aisConsent, List<AccountReference> references, String accountId, AisConsentRequestType consentRequestType) {
        if (AisConsentRequestType.GLOBAL == consentRequestType) {
            return ValidationResult.valid();
        }
        if (this.isConsentForAllAvailableAccounts(aisConsent) || !this.isValidAccountByAccess(accountId, references)) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        return ValidationResult.valid();
    }

    private boolean isValidAccountByAccess(String accountId, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> StringUtils.equals((CharSequence)a.getResourceId(), (CharSequence)accountId));
    }

    private boolean isConsentForAllAvailableAccounts(AisConsent aisConsent) {
        AisConsentData consentData = (AisConsentData)aisConsent.getConsentData();
        return Arrays.asList(consentData.getAvailableAccounts(), consentData.getAvailableAccountsWithBalance()).contains(AccountAccessType.ALL_ACCOUNTS);
    }
}

