/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CardAccountHandler {
    @Value(value="${xs2a.masked-pan-begin-chars:6}")
    private int maskedPanBeginChars;
    @Value(value="${xs2a.masked-pan-end-chars:4}")
    private int maskedPanEndChars;

    public boolean areAccountsEqual(Xs2aCardAccountDetails aspspAccount, AccountReference tppAccount) {
        String aspspMaskedPan = aspspAccount.getMaskedPan();
        return this.isMaskedPanCorrespondsToValue(aspspMaskedPan, tppAccount.getMaskedPan()) || this.isMaskedPanCorrespondsToValue(aspspMaskedPan, tppAccount.getPan());
    }

    private boolean isMaskedPanCorrespondsToValue(String maskedPan, String comparableValue) {
        if (maskedPan == null || comparableValue == null) {
            return false;
        }
        String panPrefix = StringUtils.left((String)comparableValue, (int)this.maskedPanBeginChars);
        String maskedPanPrefix = StringUtils.left((String)maskedPan, (int)this.maskedPanBeginChars);
        String panSuffix = StringUtils.right((String)comparableValue, (int)this.maskedPanEndChars);
        String maskedPanSuffix = StringUtils.right((String)maskedPan, (int)this.maskedPanEndChars);
        return panPrefix.equals(maskedPanPrefix) && panSuffix.equals(maskedPanSuffix);
    }

    public String hidePanInAccountReference(String pan) {
        if (pan == null) {
            return null;
        }
        int numberOfMaskedChars = pan.length() - (this.maskedPanBeginChars + this.maskedPanEndChars);
        String maskedPartOfPan = StringUtils.repeat((String)"*", (int)numberOfMaskedChars);
        return StringUtils.overlay((String)pan, (String)maskedPartOfPan, (int)this.maskedPanBeginChars, (int)(pan.length() - this.maskedPanEndChars));
    }
}

