/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessMultipleAccountsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountListConsentObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetAccountListValidator
extends AbstractAccountTppValidator<GetAccountListConsentObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountAccessValidator accountAccessValidator;
    private final AccountAccessMultipleAccountsValidator accountAccessMultipleAccountsValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetAccountListConsentObject consentObject) {
        AisConsent aisConsent = consentObject.getAisConsent();
        if (aisConsent.isConsentWithNotIbanAccount() && !aisConsent.isConsentForAllAvailableAccounts() && !aisConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult accountConsentValidationResult = this.accountConsentValidator.validate(aisConsent, consentObject.getRequestUri());
        if (accountConsentValidationResult.isNotValid()) {
            return accountConsentValidationResult;
        }
        ValidationResult accountAccessValidationResult = this.accountAccessValidator.validate(aisConsent, consentObject.isWithBalance());
        if (accountAccessValidationResult.isNotValid()) {
            return accountAccessValidationResult;
        }
        ValidationResult accountAccessMultipleAccountsValidatorResult = this.accountAccessMultipleAccountsValidator.validate(aisConsent, consentObject.isWithBalance());
        if (accountAccessMultipleAccountsValidatorResult.isNotValid()) {
            return accountAccessMultipleAccountsValidatorResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(aisConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountAccessValidator", "accountAccessMultipleAccountsValidator", "oauthConsentValidator"})
    public GetAccountListValidator(AccountConsentValidator accountConsentValidator, AccountAccessValidator accountAccessValidator, AccountAccessMultipleAccountsValidator accountAccessMultipleAccountsValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountAccessValidator = accountAccessValidator;
        this.accountAccessMultipleAccountsValidator = accountAccessMultipleAccountsValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

