/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiAddressMapper {
    public SpiAddress mapToSpiAddress(Xs2aAddress address) {
        if (address == null) {
            return null;
        }
        return new SpiAddress(address.getStreetName(), address.getBuildingNumber(), address.getTownName(), address.getPostCode(), Optional.ofNullable(address.getCountry()).map(Xs2aCountryCode::getCode).orElse(""));
    }

    public Xs2aAddress mapToXs2aAddress(SpiAddress address) {
        if (address == null) {
            return null;
        }
        Xs2aAddress xs2aAddress = new Xs2aAddress();
        xs2aAddress.setStreetName(address.getStreetName());
        xs2aAddress.setBuildingNumber(address.getBuildingNumber());
        xs2aAddress.setTownName(address.getTownName());
        xs2aAddress.setPostCode(address.getPostCode());
        xs2aAddress.setCountry(new Xs2aCountryCode(address.getCountry()));
        return xs2aAddress;
    }
}

