/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.CashAccountType;
import de.adorsys.psd2.xs2a.domain.account.AccountStatus;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiUsageType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aAccountDetailsMapper {
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aAddressMapper spiToXs2aAddressMapper;
    private final SpiToXs2aAmountMapper spiToXs2aAmountMapper;

    public Xs2aAccountDetails mapToXs2aAccountDetails(SpiAccountDetails accountDetails) {
        return Optional.ofNullable(accountDetails).map(ad -> new Xs2aAccountDetails(ad.getAspspAccountId(), ad.getResourceId(), ad.getIban(), ad.getBban(), ad.getPan(), ad.getMaskedPan(), ad.getMsisdn(), ad.getCurrency(), ad.getName(), ad.getDisplayName(), ad.getProduct(), this.mapToAccountType(ad.getCashSpiAccountType()), this.mapToAccountStatus(ad.getSpiAccountStatus()), ad.getBic(), ad.getLinkedAccounts(), this.mapToXs2aUsageType(ad.getUsageType()), ad.getDetails(), this.balanceMapper.mapToXs2aBalanceList(ad.getBalances()), accountDetails.getOwnerName(), Optional.ofNullable(accountDetails.getOwnerAddress()).map(this.spiToXs2aAddressMapper::mapToAddress).orElse(null))).orElse(null);
    }

    public Xs2aCardAccountDetails mapToXs2aCardAccountDetails(SpiCardAccountDetails cardAccountDetails) {
        return Optional.ofNullable(cardAccountDetails).map(ad -> new Xs2aCardAccountDetails(ad.getAspspAccountId(), ad.getResourceId(), ad.getMaskedPan(), ad.getCurrency(), ad.getName(), ad.getDisplayName(), ad.getProduct(), this.mapToAccountType(ad.getCashSpiAccountType()), this.mapToAccountStatus(ad.getSpiAccountStatus()), this.mapToXs2aUsageType(ad.getUsageType()), ad.getDetails(), this.balanceMapper.mapToXs2aBalanceList(ad.getBalances()), Optional.ofNullable(ad.getCreditLimit()).map(this.spiToXs2aAmountMapper::mapToXs2aAmount).orElse(null), ad.getOwnerName(), ad.getDebitAccounting())).orElse(null);
    }

    public List<Xs2aAccountDetails> mapToXs2aAccountDetailsList(List<SpiAccountDetails> accountDetails) {
        if (CollectionUtils.isEmpty(accountDetails)) {
            return new ArrayList<Xs2aAccountDetails>();
        }
        return accountDetails.stream().map(this::mapToXs2aAccountDetails).collect(Collectors.toList());
    }

    public List<Xs2aCardAccountDetails> mapToXs2aCardAccountDetailsList(List<SpiCardAccountDetails> cardAccountDetails) {
        if (CollectionUtils.isEmpty(cardAccountDetails)) {
            return new ArrayList<Xs2aCardAccountDetails>();
        }
        return cardAccountDetails.stream().map(this::mapToXs2aCardAccountDetails).collect(Collectors.toList());
    }

    private CashAccountType mapToAccountType(SpiAccountType spiAccountType) {
        return Optional.ofNullable(spiAccountType).map(type -> CashAccountType.valueOf(type.name())).orElse(null);
    }

    private AccountStatus mapToAccountStatus(SpiAccountStatus spiAccountStatus) {
        return Optional.ofNullable(spiAccountStatus).map(status -> AccountStatus.valueOf(status.name())).orElse(null);
    }

    private Xs2aUsageType mapToXs2aUsageType(SpiUsageType spiUsageType) {
        return Optional.ofNullable(spiUsageType).map(usage -> Xs2aUsageType.valueOf(usage.name())).orElse(null);
    }

    @ConstructorProperties(value={"balanceMapper", "spiToXs2aAddressMapper", "spiToXs2aAmountMapper"})
    public SpiToXs2aAccountDetailsMapper(SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aAddressMapper spiToXs2aAddressMapper, SpiToXs2aAmountMapper spiToXs2aAmountMapper) {
        this.balanceMapper = balanceMapper;
        this.spiToXs2aAddressMapper = spiToXs2aAddressMapper;
        this.spiToXs2aAmountMapper = spiToXs2aAmountMapper;
    }
}

