/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.ais;

import de.adorsys.psd2.model.Error405NGAIS;
import de.adorsys.psd2.model.TppMessage405AIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AIS405ErrorMapper
extends Psd2ErrorMapper<MessageError, Error405NGAIS> {
    @Override
    public Function<MessageError, Error405NGAIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    private Error405NGAIS mapToPsd2Error(MessageError messageError) {
        return new Error405NGAIS().tppMessages(this.mapToTppMessages(messageError.getTppMessages()));
    }

    private List<TppMessage405AIS> mapToTppMessages(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage405AIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

