/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor;

import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.authorization.processor.AuthorisationProcessorServiceProvider;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.AuthorisationProcessorService;

public abstract class AuthorisationProcessor {
    private AuthorisationProcessor nextProcessor;
    private final AuthorisationProcessorServiceProvider provider;

    protected AuthorisationProcessor(AuthorisationProcessorServiceProvider provider) {
        this.provider = provider;
    }

    public void setNext(AuthorisationProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public abstract ScaStatus getScaStatus();

    protected abstract AuthorisationProcessorResponse execute(AuthorisationProcessorRequest var1, AuthorisationProcessorService var2);

    public AuthorisationProcessorResponse apply(AuthorisationProcessorRequest request) {
        AuthorisationProcessorResponse processorResponse = this.process(request);
        this.getProcessorService(request).updateAuthorisation(request, processorResponse);
        return processorResponse;
    }

    AuthorisationProcessorResponse process(AuthorisationProcessorRequest request) {
        if (this.getScaStatus() == request.getScaStatus()) {
            AuthorisationProcessorService processorService = this.getProcessorService(request);
            return this.execute(request, processorService);
        }
        if (this.hasNext()) {
            return this.nextProcessor.process(request);
        }
        return null;
    }

    AuthorisationProcessorService getProcessorService(AuthorisationProcessorRequest request) {
        return this.provider.getProcessorService(request);
    }

    private boolean hasNext() {
        return this.nextProcessor != null;
    }
}

