package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.TransactionInfo;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiEntryDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiStandingOrderDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-03-10T13:44:12+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.10 (Azul Systems, Inc.)"
)
@Component
public class SpiToXs2aTransactionMapperImpl implements SpiToXs2aTransactionMapper {

    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aBalanceMapper spiToXs2aBalanceMapper;
    @Autowired
    private SpiToXs2aExchangeRateMapper spiToXs2aExchangeRateMapper;
    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;

    @Override
    public Transactions mapToXs2aTransaction(SpiTransaction spiTransaction) {
        if ( spiTransaction == null ) {
            return null;
        }

        Transactions transactions = new Transactions();

        transactions.setAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiTransaction.getSpiAmount() ) );
        transactions.setTransactionInfo( mapToTransactionInfo( spiTransaction.getSpiTransactionInfo() ) );
        transactions.setTransactionId( spiTransaction.getTransactionId() );
        transactions.setEntryReference( spiTransaction.getEntryReference() );
        transactions.setEndToEndId( spiTransaction.getEndToEndId() );
        transactions.setMandateId( spiTransaction.getMandateId() );
        transactions.setCheckId( spiTransaction.getCheckId() );
        transactions.setCreditorId( spiTransaction.getCreditorId() );
        transactions.setBookingDate( spiTransaction.getBookingDate() );
        transactions.setValueDate( spiTransaction.getValueDate() );
        transactions.setExchangeRate( spiToXs2aExchangeRateMapper.mapToExchangeRateList( spiTransaction.getExchangeRate() ) );
        transactions.setProprietaryBankTransactionCode( spiTransaction.getProprietaryBankTransactionCode() );
        transactions.setAdditionalInformation( spiTransaction.getAdditionalInformation() );
        transactions.setAdditionalInformationStructured( spiAdditionalInformationStructuredToXs2aAdditionalInformationStructured( spiTransaction.getAdditionalInformationStructured() ) );
        transactions.setBalanceAfterTransaction( spiToXs2aBalanceMapper.mapToXs2aBalance( spiTransaction.getBalanceAfterTransaction() ) );
        transactions.setBatchIndicator( spiTransaction.getBatchIndicator() );
        transactions.setBatchNumberOfTransactions( spiTransaction.getBatchNumberOfTransactions() );
        transactions.setEntryDetails( mapToEntryDetailsList( spiTransaction.getEntryDetails() ) );

        transactions.setBankTransactionCodeCode( new BankTransactionCode(spiTransaction.getBankTransactionCodeCode()) );

        return transactions;
    }

    @Override
    public List<Transactions> mapToXs2aTransactionList(List<SpiTransaction> spiTransactions) {
        if ( spiTransactions == null ) {
            return null;
        }

        List<Transactions> list = new ArrayList<Transactions>( spiTransactions.size() );
        for ( SpiTransaction spiTransaction : spiTransactions ) {
            list.add( mapToXs2aTransaction( spiTransaction ) );
        }

        return list;
    }

    @Override
    public EntryDetails mapToEntryDetails(SpiEntryDetails spiEntryDetails) {
        if ( spiEntryDetails == null ) {
            return null;
        }

        EntryDetails entryDetails = new EntryDetails();

        entryDetails.setTransactionInfo( mapToTransactionInfo( spiEntryDetails.getSpiTransactionInfo() ) );
        entryDetails.setEndToEndId( spiEntryDetails.getEndToEndId() );
        entryDetails.setMandateId( spiEntryDetails.getMandateId() );
        entryDetails.setCheckId( spiEntryDetails.getCheckId() );
        entryDetails.setCreditorId( spiEntryDetails.getCreditorId() );
        entryDetails.setTransactionAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiEntryDetails.getTransactionAmount() ) );
        entryDetails.setCurrencyExchange( spiToXs2aExchangeRateMapper.mapToExchangeRateList( spiEntryDetails.getCurrencyExchange() ) );

        return entryDetails;
    }

    @Override
    public List<EntryDetails> mapToEntryDetailsList(List<SpiEntryDetails> spiEntryDetails) {
        if ( spiEntryDetails == null ) {
            return null;
        }

        List<EntryDetails> list = new ArrayList<EntryDetails>( spiEntryDetails.size() );
        for ( SpiEntryDetails spiEntryDetails1 : spiEntryDetails ) {
            list.add( mapToEntryDetails( spiEntryDetails1 ) );
        }

        return list;
    }

    @Override
    public TransactionInfo mapToTransactionInfo(SpiTransactionInfo spiTransactionInfo) {
        if ( spiTransactionInfo == null ) {
            return null;
        }

        List<String> remittanceInformationUnstructuredArray = null;
        List<String> remittanceInformationStructuredArray = null;
        String creditorName = null;
        AccountReference creditorAccount = null;
        String creditorAgent = null;
        String ultimateCreditor = null;
        String debtorName = null;
        AccountReference debtorAccount = null;
        String debtorAgent = null;
        String ultimateDebtor = null;
        String remittanceInformationUnstructured = null;
        String remittanceInformationStructured = null;

        List<String> list = spiTransactionInfo.getRemittanceInformationUnstructuredArray();
        if ( list != null ) {
            remittanceInformationUnstructuredArray = new ArrayList<String>( list );
        }
        List<String> list1 = spiTransactionInfo.getRemittanceInformationStructuredArray();
        if ( list1 != null ) {
            remittanceInformationStructuredArray = new ArrayList<String>( list1 );
        }
        creditorName = spiTransactionInfo.getCreditorName();
        creditorAccount = spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( spiTransactionInfo.getCreditorAccount() );
        creditorAgent = spiTransactionInfo.getCreditorAgent();
        ultimateCreditor = spiTransactionInfo.getUltimateCreditor();
        debtorName = spiTransactionInfo.getDebtorName();
        debtorAccount = spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( spiTransactionInfo.getDebtorAccount() );
        debtorAgent = spiTransactionInfo.getDebtorAgent();
        ultimateDebtor = spiTransactionInfo.getUltimateDebtor();
        remittanceInformationUnstructured = spiTransactionInfo.getRemittanceInformationUnstructured();
        remittanceInformationStructured = spiTransactionInfo.getRemittanceInformationStructured();

        PurposeCode purposeCode = PurposeCode.fromValue(spiTransactionInfo.getPurposeCode());

        TransactionInfo transactionInfo = new TransactionInfo( creditorName, creditorAccount, creditorAgent, ultimateCreditor, debtorName, debtorAccount, debtorAgent, ultimateDebtor, remittanceInformationUnstructured, remittanceInformationUnstructuredArray, remittanceInformationStructured, remittanceInformationStructuredArray, purposeCode );

        return transactionInfo;
    }

    protected Xs2aStandingOrderDetails spiStandingOrderDetailsToXs2aStandingOrderDetails(SpiStandingOrderDetails spiStandingOrderDetails) {
        if ( spiStandingOrderDetails == null ) {
            return null;
        }

        Xs2aStandingOrderDetails xs2aStandingOrderDetails = new Xs2aStandingOrderDetails();

        xs2aStandingOrderDetails.setStartDate( spiStandingOrderDetails.getStartDate() );
        xs2aStandingOrderDetails.setEndDate( spiStandingOrderDetails.getEndDate() );
        xs2aStandingOrderDetails.setExecutionRule( spiStandingOrderDetails.getExecutionRule() );
        xs2aStandingOrderDetails.setWithinAMonthFlag( spiStandingOrderDetails.getWithinAMonthFlag() );
        xs2aStandingOrderDetails.setFrequency( spiStandingOrderDetails.getFrequency() );
        List<String> list = spiStandingOrderDetails.getMonthsOfExecution();
        if ( list != null ) {
            xs2aStandingOrderDetails.setMonthsOfExecution( new ArrayList<String>( list ) );
        }
        xs2aStandingOrderDetails.setMultiplicator( spiStandingOrderDetails.getMultiplicator() );
        xs2aStandingOrderDetails.setDayOfExecution( spiStandingOrderDetails.getDayOfExecution() );
        xs2aStandingOrderDetails.setLimitAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiStandingOrderDetails.getLimitAmount() ) );

        return xs2aStandingOrderDetails;
    }

    protected Xs2aAdditionalInformationStructured spiAdditionalInformationStructuredToXs2aAdditionalInformationStructured(SpiAdditionalInformationStructured spiAdditionalInformationStructured) {
        if ( spiAdditionalInformationStructured == null ) {
            return null;
        }

        Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured = new Xs2aAdditionalInformationStructured();

        xs2aAdditionalInformationStructured.setStandingOrderDetails( spiStandingOrderDetailsToXs2aStandingOrderDetails( spiAdditionalInformationStructured.getStandingOrderDetails() ) );

        return xs2aAdditionalInformationStructured;
    }
}
