/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.xs2a.config.Xs2aEndpointPathConstant;
import de.adorsys.psd2.xs2a.web.request.RequestPathResolver;
import java.beans.ConstructorProperties;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
public class Xs2aEndpointChecker {
    private static final AntPathMatcher matcher = new AntPathMatcher();
    private final RequestPathResolver requestPathResolver;

    public boolean isXs2aEndpoint(HttpServletRequest request) {
        String requestPath = this.requestPathResolver.resolveRequestPath(request);
        return Stream.of(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths()).anyMatch(en -> matcher.match(en, requestPath));
    }

    @ConstructorProperties(value={"requestPathResolver"})
    public Xs2aEndpointChecker(RequestPathResolver requestPathResolver) {
        this.requestPathResolver = requestPathResolver;
    }
}

