/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.OauthPaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetPaymentInitiationAuthorisationScaStatusValidator
extends AbstractPisValidator<GetPaymentInitiationAuthorisationScaStatusPO> {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentInitiationAuthorisationScaStatusValidator.class);
    private final PisAuthorisationValidator pisAuthorisationValidator;
    private final OauthPaymentValidator oauthPaymentValidator;

    public GetPaymentInitiationAuthorisationScaStatusValidator(PisAuthorisationValidator pisAuthorisationValidator, OauthPaymentValidator oauthPaymentValidator) {
        this.pisAuthorisationValidator = pisAuthorisationValidator;
        this.oauthPaymentValidator = oauthPaymentValidator;
    }

    @Override
    protected ValidationResult executeBusinessValidation(GetPaymentInitiationAuthorisationScaStatusPO paymentObject) {
        PisCommonPaymentResponse response = paymentObject.getPisCommonPaymentResponse();
        String authorisationId = paymentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, response);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        ValidationResult oauthPaymentValidationResult = this.oauthPaymentValidator.validate(paymentObject.getPisCommonPaymentResponse());
        if (oauthPaymentValidationResult.isNotValid()) {
            return oauthPaymentValidationResult;
        }
        return ValidationResult.valid();
    }
}

