/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.AbstractConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentAuthorisationObject;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationPsuDataChecker;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStatusChecker;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentAuthorisationValidator
extends AbstractConsentTppValidator<CreateConsentAuthorisationObject> {
    private final AuthorisationPsuDataChecker authorisationPsuDataChecker;
    private final AuthorisationStatusChecker authorisationStatusChecker;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CreateConsentAuthorisationObject createConsentAuthorisationObject) {
        PsuIdData psuDataFromRequest = createConsentAuthorisationObject.getPsuIdDataFromRequest();
        AisConsent aisConsent = createConsentAuthorisationObject.getAisConsent();
        List psuDataFromDb = aisConsent.getPsuIdDataList();
        if (this.authorisationPsuDataChecker.isPsuDataWrong(aisConsent.isMultilevelScaRequired(), psuDataFromDb, psuDataFromRequest)) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID);
        }
        List accountConsentAuthorisations = aisConsent.getAuthorisations();
        List<Authorisation> authorisations = accountConsentAuthorisations.stream().map(auth -> new Authorisation(auth.getId(), auth.getPsuIdData(), auth.getConsentId(), AuthorisationType.CONSENT, auth.getScaStatus())).collect(Collectors.toList());
        boolean isFinalised = this.authorisationStatusChecker.isFinalised(psuDataFromRequest, authorisations, AuthorisationType.CONSENT);
        if (isFinalised) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_409, (MessageErrorCode)MessageErrorCode.STATUS_INVALID);
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"authorisationPsuDataChecker", "authorisationStatusChecker"})
    public CreateConsentAuthorisationValidator(AuthorisationPsuDataChecker authorisationPsuDataChecker, AuthorisationStatusChecker authorisationStatusChecker) {
        this.authorisationPsuDataChecker = authorisationPsuDataChecker;
        this.authorisationStatusChecker = authorisationStatusChecker;
    }
}

