/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aPisCommonPaymentService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;

    public CreatePisCommonPaymentResponse createCommonPayment(PisPaymentInfo request) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.createCommonPayment(request);
        if (response.hasError()) {
            log.info("Payment ID: [{}]. Pis common payment cannot be created, because can't save to cms DB", (Object)request.getPaymentId());
            return null;
        }
        return (CreatePisCommonPaymentResponse)response.getPayload();
    }

    public Optional<PisCommonPaymentResponse> getPisCommonPaymentById(String paymentId) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.getCommonPaymentById(paymentId);
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((PisCommonPaymentResponse)response.getPayload());
    }

    public boolean updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.updateMultilevelSca(paymentId, multilevelScaRequired);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted"})
    public Xs2aPisCommonPaymentService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
    }
}

