/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aConsentAuthorisationMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aConsentService.class);
    private final RequestProviderService requestProviderService;
    private final Xs2aConsentAuthorisationMapper xs2aConsentAuthorisationMapper;
    private final Xs2aAuthorisationService authorisationService;
    private final ScaApproachResolver scaApproachResolver;

    public Optional<CreateAuthorisationResponse> createConsentAuthorisation(String consentId, ScaStatus scaStatus, PsuIdData psuData) {
        String tppRedirectURI = this.requestProviderService.getTppRedirectURI();
        String tppNOKRedirectURI = this.requestProviderService.getTppNokRedirectURI();
        CreateAuthorisationRequest request = this.xs2aConsentAuthorisationMapper.mapToAuthorisationRequest(scaStatus, psuData, this.scaApproachResolver.resolveScaApproach(), tppRedirectURI, tppNOKRedirectURI);
        return this.authorisationService.createAuthorisation(request, consentId, AuthorisationType.CONSENT);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.authorisationService.getAuthorisationScaStatus(authorisationId, consentId, AuthorisationType.CONSENT);
    }

    @ConstructorProperties(value={"requestProviderService", "xs2aConsentAuthorisationMapper", "authorisationService", "scaApproachResolver"})
    public Xs2aConsentService(RequestProviderService requestProviderService, Xs2aConsentAuthorisationMapper xs2aConsentAuthorisationMapper, Xs2aAuthorisationService authorisationService, ScaApproachResolver scaApproachResolver) {
        this.requestProviderService = requestProviderService;
        this.xs2aConsentAuthorisationMapper = xs2aConsentAuthorisationMapper;
        this.authorisationService = authorisationService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

